/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareproducts.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.accounting.common.AccountingConstants;
import org.apache.fineract.accounting.common.AccountingRuleType;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.exception.InvalidCurrencyException;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.charge.domain.ChargeRepositoryWrapper;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.shareproducts.data.ShareProductMarketPriceData;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProduct;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProductMarketPrice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShareProductDataSerializer {
    private static final Set<String> supportedParametersForCreate = new HashSet<String>(Arrays.asList("locale", "name", "shortName", "shortName", "description", "externalId", "totalShares", "currencyCode", "digitsAfterDecimal", "digitsAfterDecimal", "inMultiplesOf", "sharesIssued", "unitPrice", "minimumShares", "nominalShares", "maximumShares", "marketPricePeriods", "chargesSelected", "allowDividendCalculationForInactiveClients", "lockinPeriodFrequency", "lockinPeriodFrequencyType", "minimumActivePeriodForDividends", "minimumactiveperiodFrequencyType", "shareCapital", "accountingRule", AccountingConstants.SharesProductAccountingParams.INCOME_FROM_FEES.getValue(), AccountingConstants.SharesProductAccountingParams.SHARES_EQUITY.getValue(), AccountingConstants.SharesProductAccountingParams.SHARES_REFERENCE.getValue(), AccountingConstants.SharesProductAccountingParams.SHARES_SUSPENSE.getValue()));
    private static final Set<String> supportedParametersForDivident = new HashSet<String>(Arrays.asList("locale", "dateFormat", "dividendPeriodStartDate", "dividendPeriodEndDate", "dividendAmount"));
    private final FromJsonHelper fromApiJsonHelper;
    private final ChargeRepositoryWrapper chargeRepository;
    private final PlatformSecurityContext platformSecurityContext;

    @Autowired
    public ShareProductDataSerializer(FromJsonHelper fromApiJsonHelper, ChargeRepositoryWrapper chargeRepository, PlatformSecurityContext platformSecurityContext) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.chargeRepository = chargeRepository;
        this.platformSecurityContext = platformSecurityContext;
    }

    public ShareProduct validateAndCreate(JsonCommand jsonCommand) {
        Long maximumClientShares;
        if (StringUtils.isBlank((CharSequence)jsonCommand.json())) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, jsonCommand.json(), (Collection)supportedParametersForCreate);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("sharesproduct");
        JsonElement element = jsonCommand.parsedJson();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(element.getAsJsonObject());
        String productName = this.fromApiJsonHelper.extractStringNamed("name", element);
        baseDataValidator.reset().parameter("name").value((Object)productName).notBlank().notExceedingLengthOf(Integer.valueOf(200));
        String shortName = this.fromApiJsonHelper.extractStringNamed("shortName", element);
        baseDataValidator.reset().parameter("shortName").value((Object)shortName).notBlank().notExceedingLengthOf(Integer.valueOf(4));
        String description = this.fromApiJsonHelper.extractStringNamed("description", element);
        baseDataValidator.reset().parameter("description").value((Object)description).notBlank().notExceedingLengthOf(Integer.valueOf(500));
        String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
        Long totalNumberOfShares = this.fromApiJsonHelper.extractLongNamed("totalShares", element);
        baseDataValidator.reset().parameter("totalShares").value((Object)totalNumberOfShares).notNull().longGreaterThanZero();
        Long sharesIssued = this.fromApiJsonHelper.extractLongNamed("sharesIssued", element);
        if (sharesIssued != null && totalNumberOfShares != null && sharesIssued > totalNumberOfShares) {
            baseDataValidator.reset().parameter("sharesIssued").value((Object)sharesIssued).failWithCodeNoParameterAddedToErrorCode("sharesIssued.cannot.be.greater.than.totalNumberOfShares", new Object[0]);
        }
        String currencyCode = this.fromApiJsonHelper.extractStringNamed("currencyCode", element);
        Integer digitsAfterDecimal = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("digitsAfterDecimal", element);
        Integer inMultiplesOf = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("inMultiplesOf", element);
        MonetaryCurrency currency = new MonetaryCurrency(currencyCode, digitsAfterDecimal.intValue(), inMultiplesOf);
        BigDecimal unitPrice = this.fromApiJsonHelper.extractBigDecimalNamed("unitPrice", element, locale);
        baseDataValidator.reset().parameter("unitPrice").value((Object)unitPrice).notNull().positiveAmount();
        BigDecimal shareCapitalValue = BigDecimal.ONE;
        if (sharesIssued != null && unitPrice != null) {
            shareCapitalValue = BigDecimal.valueOf(sharesIssued).multiply(unitPrice);
        }
        Integer accountingRule = this.fromApiJsonHelper.extractIntegerNamed("accountingRule", element, locale);
        baseDataValidator.reset().parameter("accountingRule").value((Object)accountingRule).notNull().integerGreaterThanZero();
        AccountingRuleType accountingRuleType = null;
        if (accountingRule != null) {
            accountingRuleType = AccountingRuleType.fromInt((Integer)accountingRule);
        }
        Long minimumClientShares = this.fromApiJsonHelper.extractLongNamed("minimumShares", element);
        Long nominalClientShares = this.fromApiJsonHelper.extractLongNamed("nominalShares", element);
        baseDataValidator.reset().parameter("nominalShares").value((Object)nominalClientShares).notNull().longGreaterThanZero();
        if (minimumClientShares != null && nominalClientShares != null && !minimumClientShares.equals(nominalClientShares)) {
            baseDataValidator.reset().parameter("nominalShares").value((Object)nominalClientShares).longGreaterThanNumber(minimumClientShares);
        }
        if ((maximumClientShares = this.fromApiJsonHelper.extractLongNamed("maximumShares", element)) != null && nominalClientShares != null && !maximumClientShares.equals(nominalClientShares)) {
            baseDataValidator.reset().parameter("maximumShares").value((Object)maximumClientShares).longGreaterThanNumber(nominalClientShares);
        }
        Set marketPriceSet = this.asembleShareMarketPrice(element);
        Set charges = this.assembleListOfProductCharges(element, currencyCode);
        Boolean allowdividendsForInactiveClients = this.fromApiJsonHelper.extractBooleanNamed("allowDividendCalculationForInactiveClients", element);
        Integer minimumActivePeriod = this.fromApiJsonHelper.extractIntegerNamed("minimumActivePeriodForDividends", element, locale);
        PeriodFrequencyType minimumActivePeriodType = this.extractPeriodType("minimumactiveperiodFrequencyType", element);
        if (minimumActivePeriod != null) {
            baseDataValidator.reset().parameter("minimumactiveperiodFrequencyType").value((Object)minimumActivePeriodType.getValue()).integerSameAsNumber(PeriodFrequencyType.DAYS.getValue());
        }
        Integer lockinPeriod = this.fromApiJsonHelper.extractIntegerNamed("lockinPeriodFrequency", element, locale);
        PeriodFrequencyType lockPeriodType = this.extractPeriodType("lockinPeriodFrequencyType", element);
        ShareProduct product = new ShareProduct(productName, shortName, description, externalId, currency, totalNumberOfShares, sharesIssued, unitPrice, shareCapitalValue, minimumClientShares, nominalClientShares, maximumClientShares, marketPriceSet, charges, allowdividendsForInactiveClients, lockinPeriod, lockPeriodType, minimumActivePeriod, minimumActivePeriodType, accountingRuleType);
        for (ShareProductMarketPrice data : marketPriceSet) {
            data.setShareProduct(product);
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        return product;
    }

    private PeriodFrequencyType extractPeriodType(String paramName, JsonElement element) {
        PeriodFrequencyType frequencyType = PeriodFrequencyType.INVALID;
        frequencyType = PeriodFrequencyType.fromInt((Integer)this.fromApiJsonHelper.extractIntegerWithLocaleNamed(paramName, element));
        return frequencyType;
    }

    private Set<ShareProductMarketPriceData> asembleShareMarketPriceForUpdate(JsonElement element) {
        HashSet<ShareProductMarketPriceData> set = null;
        if (this.fromApiJsonHelper.parameterExists("marketPricePeriods", element)) {
            set = new HashSet<ShareProductMarketPriceData>();
            JsonArray array = this.fromApiJsonHelper.extractJsonArrayNamed("marketPricePeriods", element);
            for (JsonElement arrayElement : array) {
                Long id = this.fromApiJsonHelper.extractLongNamed("id", arrayElement);
                LocalDate localDate = this.fromApiJsonHelper.extractLocalDateNamed("fromDate", arrayElement);
                BigDecimal shareValue = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("shareValue", arrayElement);
                ShareProductMarketPriceData obj = new ShareProductMarketPriceData(id, localDate, shareValue);
                set.add(obj);
            }
        }
        return set;
    }

    private Set<ShareProductMarketPrice> asembleShareMarketPrice(JsonElement element) {
        HashSet<Object> set = new HashSet<ShareProductMarketPrice>();
        if (this.fromApiJsonHelper.parameterExists("marketPricePeriods", element)) {
            set = new HashSet();
            JsonArray array = this.fromApiJsonHelper.extractJsonArrayNamed("marketPricePeriods", element);
            for (JsonElement arrayElement : array) {
                LocalDate localDate = this.fromApiJsonHelper.extractLocalDateNamed("fromDate", arrayElement);
                BigDecimal shareValue = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("shareValue", arrayElement);
                ShareProductMarketPrice obj = new ShareProductMarketPrice(localDate, shareValue);
                set.add(obj);
            }
        }
        return set;
    }

    private Set<Charge> assembleListOfProductCharges(JsonElement element, String currencyCode) {
        JsonArray chargesArray;
        HashSet<Charge> charges = new HashSet<Charge>();
        if (this.fromApiJsonHelper.parameterExists("chargesSelected", element) && (chargesArray = this.fromApiJsonHelper.extractJsonArrayNamed("chargesSelected", element)) != null) {
            for (int i = 0; i < chargesArray.size(); ++i) {
                JsonObject jsonObject = chargesArray.get(i).getAsJsonObject();
                if (!jsonObject.has("id")) continue;
                Long id = jsonObject.get("id").getAsLong();
                Charge charge = this.chargeRepository.findOneWithNotFoundDetection(id);
                if (!currencyCode.equals(charge.getCurrencyCode())) {
                    String errorMessage = "Charge and Share Product must have the same currency.";
                    throw new InvalidCurrencyException("charge", "attach.to.share.product", "Charge and Share Product must have the same currency.", new Object[0]);
                }
                charges.add(charge);
            }
        }
        return charges;
    }

    public Map<String, Object> validateAndUpdate(JsonCommand jsonCommand, ShareProduct product) {
        PeriodFrequencyType lockPeriod;
        Integer lockinPeriod;
        Boolean allowdividendsForInactiveClients;
        String currencyCode;
        Set charges;
        Set marketPrice;
        String description;
        HashMap<String, Object> actualChanges = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)jsonCommand.json())) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, jsonCommand.json(), (Collection)supportedParametersForCreate);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("sharesproduct");
        JsonElement element = jsonCommand.parsedJson();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(element.getAsJsonObject());
        if (this.fromApiJsonHelper.parameterExists("name", element)) {
            String productName = this.fromApiJsonHelper.extractStringNamed("name", element);
            baseDataValidator.reset().parameter("name").value((Object)productName).notBlank();
            if (product.setProductName(productName)) {
                actualChanges.put("name", productName);
            }
        }
        if (this.fromApiJsonHelper.parameterExists("shortName", element)) {
            String shortName = this.fromApiJsonHelper.extractStringNamed("shortName", element);
            baseDataValidator.reset().parameter("shortName").value((Object)shortName).notBlank();
            if (product.setShortName(shortName)) {
                actualChanges.put("shortName", shortName);
            }
        }
        if (this.fromApiJsonHelper.parameterExists("description", element) && product.setDescription(description = this.fromApiJsonHelper.extractStringNamed("description", element))) {
            actualChanges.put("description", description);
        }
        if (this.fromApiJsonHelper.parameterExists("externalId", element)) {
            String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
            baseDataValidator.reset().parameter("externalId").value((Object)externalId).notBlank();
            if (product.setExternalId(externalId)) {
                actualChanges.put("externalId", externalId);
            }
        }
        if (this.fromApiJsonHelper.parameterExists("totalShares", element)) {
            Long totalShares = this.fromApiJsonHelper.extractLongNamed("totalShares", element);
            baseDataValidator.reset().parameter("totalShares").value((Object)totalShares).notNull().longGreaterThanZero();
            if (product.setTotalShares(totalShares)) {
                actualChanges.put("totalShares", totalShares);
            }
        }
        Long sharesIssued = null;
        if (this.fromApiJsonHelper.parameterExists("sharesIssued", element)) {
            sharesIssued = this.fromApiJsonHelper.extractLongNamed("sharesIssued", element);
            if (product.setTotalIssuedShares(sharesIssued)) {
                actualChanges.put("sharesIssued", sharesIssued);
            }
        } else {
            product.setTotalIssuedShares(sharesIssued);
        }
        if (sharesIssued != null && product.getSubscribedShares() != null && sharesIssued < product.getSubscribedShares()) {
            baseDataValidator.reset().parameter("sharesIssued").value((Object)sharesIssued).failWithCodeNoParameterAddedToErrorCode("sharesissued.can.not.be.lessthan.accounts.subscribed.shares", new Object[0]);
        }
        if (this.fromApiJsonHelper.parameterExists("currencyCode", element) && this.fromApiJsonHelper.parameterExists("digitsAfterDecimal", element) && this.fromApiJsonHelper.parameterExists("inMultiplesOf", element)) {
            String currencyCode2 = this.fromApiJsonHelper.extractStringNamed("currencyCode", element);
            Integer digitsAfterDecimal = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("digitsAfterDecimal", element);
            Integer inMultiplesOf = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("inMultiplesOf", element);
            MonetaryCurrency currency = new MonetaryCurrency(currencyCode2, digitsAfterDecimal.intValue(), inMultiplesOf);
            if (product.setMonetaryCurrency(currency)) {
                actualChanges.put("currencyCode", currency);
            }
        }
        BigDecimal unitPrice = null;
        if (this.fromApiJsonHelper.parameterExists("unitPrice", element)) {
            unitPrice = this.fromApiJsonHelper.extractBigDecimalNamed("unitPrice", element, locale);
            baseDataValidator.reset().parameter("unitPrice").value((Object)unitPrice).notNull().positiveAmount();
            if (product.setUnitPrice(unitPrice)) {
                actualChanges.put("unitPrice", unitPrice);
            }
        }
        if (this.fromApiJsonHelper.parameterExists("accountingRule", element)) {
            Integer accountingRule = this.fromApiJsonHelper.extractIntegerWithLocaleNamed("accountingRule", element);
            baseDataValidator.reset().parameter("accountingRule").value((Object)accountingRule).notNull().integerGreaterThanZero();
            if (product.setAccountingRule(accountingRule)) {
                actualChanges.put("accountingRule", accountingRule);
            }
        }
        if (this.fromApiJsonHelper.parameterExists("minimumShares", element)) {
            Long minimumClientShares = this.fromApiJsonHelper.extractLongNamed("minimumShares", element);
            baseDataValidator.reset().parameter("minimumShares").value((Object)minimumClientShares).notNull().longGreaterThanZero();
            if (product.setMinimumShares(minimumClientShares)) {
                actualChanges.put("minimumShares", minimumClientShares);
            }
        }
        if (this.fromApiJsonHelper.parameterExists("nominalShares", element)) {
            Long nominalClientShares = this.fromApiJsonHelper.extractLongNamed("nominalShares", element);
            baseDataValidator.reset().parameter("nominalShares").value((Object)nominalClientShares).notNull().longGreaterThanZero();
            if (product.setNominalShares(nominalClientShares)) {
                actualChanges.put("nominalShares", nominalClientShares);
            }
        }
        if (this.fromApiJsonHelper.parameterExists("maximumShares", element)) {
            Long maximumClientShares = this.fromApiJsonHelper.extractLongNamed("maximumShares", element);
            baseDataValidator.reset().parameter("maximumShares").value((Object)maximumClientShares).notNull().longGreaterThanZero();
            if (product.setMaximumShares(maximumClientShares)) {
                actualChanges.put("maximumShares", maximumClientShares);
            }
        }
        if (this.fromApiJsonHelper.parameterExists("marketPricePeriods", element) && product.setMarketPrice(marketPrice = this.asembleShareMarketPriceForUpdate(element))) {
            actualChanges.put("marketPricePeriods", marketPrice);
        }
        if (this.fromApiJsonHelper.parameterExists("chargesSelected", element) && product.setCharges(charges = this.assembleListOfProductCharges(element, currencyCode = this.fromApiJsonHelper.extractStringNamed("currencyCode", element)))) {
            actualChanges.put("chargesSelected", charges);
        }
        if (this.fromApiJsonHelper.parameterExists("allowDividendCalculationForInactiveClients", element) && product.setAllowDividendCalculationForInactiveClients(allowdividendsForInactiveClients = this.fromApiJsonHelper.extractBooleanNamed("allowDividendCalculationForInactiveClients", element))) {
            actualChanges.put("allowDividendCalculationForInactiveClients", allowdividendsForInactiveClients);
        }
        Integer minimumActivePeriod = null;
        if (this.fromApiJsonHelper.parameterExists("minimumActivePeriodForDividends", element) && product.setminimumActivePeriod(minimumActivePeriod = this.fromApiJsonHelper.extractIntegerNamed("minimumActivePeriodForDividends", element, locale))) {
            actualChanges.put("minimumActivePeriodForDividends", minimumActivePeriod);
        }
        if (this.fromApiJsonHelper.parameterExists("minimumactiveperiodFrequencyType", element)) {
            PeriodFrequencyType minimumActivePeriodType = this.extractPeriodType("minimumactiveperiodFrequencyType", element);
            if (minimumActivePeriod != null) {
                baseDataValidator.reset().parameter("minimumactiveperiodFrequencyType").value((Object)minimumActivePeriodType.getValue()).integerSameAsNumber(PeriodFrequencyType.DAYS.getValue());
            }
            if (product.setminimumActivePeriodFrequencyType(minimumActivePeriodType)) {
                actualChanges.put("minimumactiveperiodFrequencyType", minimumActivePeriodType);
            }
        }
        if (this.fromApiJsonHelper.parameterExists("lockinPeriodFrequency", element) && product.setLockinPeriod(lockinPeriod = this.fromApiJsonHelper.extractIntegerNamed("lockinPeriodFrequency", element, locale))) {
            actualChanges.put("lockinPeriodFrequency", lockinPeriod);
        }
        if (this.fromApiJsonHelper.parameterExists("lockinPeriodFrequencyType", element) && product.setLockPeriodFrequencyType(lockPeriod = this.extractPeriodType("lockinPeriodFrequencyType", element))) {
            actualChanges.put("lockinPeriodFrequencyType", lockPeriod);
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        if (sharesIssued != null || unitPrice != null) {
            BigDecimal shareCapitalValue;
            if (sharesIssued == null) {
                sharesIssued = product.getTotalShares();
            }
            if (unitPrice == null) {
                unitPrice = product.getUnitPrice();
            }
            if (product.setshareCapitalValue(shareCapitalValue = BigDecimal.valueOf(sharesIssued).multiply(unitPrice))) {
                actualChanges.put("shareCapital", shareCapitalValue);
            }
        }
        return actualChanges;
    }

    public void validateDividendDetails(JsonCommand jsonCommand) {
        if (StringUtils.isBlank((CharSequence)jsonCommand.json())) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, jsonCommand.json(), (Collection)supportedParametersForDivident);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("sharesproduct.dividend.processing");
        JsonElement element = jsonCommand.parsedJson();
        LocalDate dividendPeriodStartDate = this.fromApiJsonHelper.extractLocalDateNamed("dividendPeriodStartDate", element);
        baseDataValidator.reset().parameter("dividendPeriodStartDate").value((Object)dividendPeriodStartDate).notBlank();
        LocalDate dividendPeriodEndDate = this.fromApiJsonHelper.extractLocalDateNamed("dividendPeriodEndDate", element);
        baseDataValidator.reset().parameter("dividendPeriodStartDate").value((Object)dividendPeriodEndDate).notBlank().validateDateAfter(dividendPeriodStartDate);
        BigDecimal dividendAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("dividendAmount", element);
        baseDataValidator.reset().parameter("dividendAmount").value((Object)dividendAmount).notBlank().positiveAmount();
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

