/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.jobs.applyannualfeeforsavings;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.portfolio.savings.data.SavingsAccountAnnualFeeData;
import org.apache.fineract.portfolio.savings.service.SavingsAccountChargeReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class ApplyAnnualFeeForSavingsTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplyAnnualFeeForSavingsTasklet.class);
    private final SavingsAccountChargeReadPlatformService savingsAccountChargeReadPlatformService;
    private final SavingsAccountWritePlatformService savingsAccountWritePlatformService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Collection annualFeeData = this.savingsAccountChargeReadPlatformService.retrieveChargesWithAnnualFeeDue();
        for (SavingsAccountAnnualFeeData savingsAccountReference : annualFeeData) {
            try {
                this.savingsAccountWritePlatformService.applyAnnualFee(savingsAccountReference.getId(), savingsAccountReference.getAccountId());
            }
            catch (PlatformApiDataValidationException e) {
                List errors = e.getErrors();
                for (ApiParameterError error : errors) {
                    log.error("Apply annual fee failed for account: {} with message {}", (Object)savingsAccountReference.getAccountNo(), (Object)error);
                }
            }
            catch (Exception ex) {
                log.error("Apply annual fee failed for account: {}", (Object)savingsAccountReference.getAccountNo(), (Object)ex);
            }
        }
        log.debug("{}: Records affected by applyAnnualFeeForSavings: {}", (Object)ThreadLocalContextUtil.getTenant().getName(), (Object)annualFeeData.size());
        return RepeatStatus.FINISHED;
    }

    @Generated
    public ApplyAnnualFeeForSavingsTasklet(SavingsAccountChargeReadPlatformService savingsAccountChargeReadPlatformService, SavingsAccountWritePlatformService savingsAccountWritePlatformService) {
        this.savingsAccountChargeReadPlatformService = savingsAccountChargeReadPlatformService;
        this.savingsAccountWritePlatformService = savingsAccountWritePlatformService;
    }
}

