/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.data;

import com.google.gson.JsonObject;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.interoperation.data.ExtensionData;
import org.apache.fineract.interoperation.data.GeoCodeData;
import org.apache.fineract.interoperation.data.InteropRequestData;
import org.apache.fineract.interoperation.data.InteropTransactionTypeData;
import org.apache.fineract.interoperation.data.MoneyData;
import org.apache.fineract.interoperation.domain.InteropTransactionRole;

public class InteropTransactionRequestData
extends InteropRequestData {
    static final String[] PARAMS = new String[]{"transactionCode", "requestCode", "accountId", "amount", "transactionRole", "transactionType", "note", "geoCode", "expiration", "extensionList", "locale", "dateFormat"};

    public InteropTransactionRequestData(@NotNull String transactionCode, @NotNull String requestCode, @NotNull String accountId, @NotNull MoneyData amount, @NotNull InteropTransactionTypeData transactionType, String note, GeoCodeData geoCode, LocalDateTime expiration, List<ExtensionData> extensionList) {
        super(transactionCode, requestCode, accountId, amount, InteropTransactionRole.PAYER, transactionType, note, geoCode, expiration, extensionList);
    }

    public InteropTransactionRequestData(@NotNull String transactionCode, @NotNull String requestCode, @NotNull String accountId, @NotNull MoneyData amount, @NotNull InteropTransactionTypeData transactionType) {
        this(transactionCode, requestCode, accountId, amount, transactionType, null, null, null, null);
    }

    private InteropTransactionRequestData(InteropRequestData other) {
        this(other.getTransactionCode(), other.getRequestCode(), other.getAccountId(), other.getAmount(), other.getTransactionType(), other.getNote(), other.getGeoCode(), other.getExpiration(), other.getExtensionList());
    }

    public static InteropTransactionRequestData validateAndParse(DataValidatorBuilder dataValidator, JsonObject element, FromJsonHelper jsonHelper) {
        if (element == null) {
            return null;
        }
        jsonHelper.checkForUnsupportedParameters(element, Arrays.asList(PARAMS));
        InteropRequestData interopRequestData = InteropRequestData.validateAndParse((DataValidatorBuilder)dataValidator, (JsonObject)element, (FromJsonHelper)jsonHelper);
        DataValidatorBuilder dataValidatorCopy = dataValidator.reset().parameter("requestCode").value((Object)interopRequestData.getRequestCode()).notNull();
        dataValidatorCopy = dataValidatorCopy.reset().parameter("transactionType").value((Object)interopRequestData.getTransactionType()).notNull();
        dataValidatorCopy = dataValidatorCopy.reset().parameter("transactionRole").value((Object)interopRequestData.getTransactionRole()).ignoreIfNull().isOneOfTheseValues(new Object[]{InteropTransactionRole.PAYER});
        dataValidator.merge(dataValidatorCopy);
        return dataValidator.hasError() ? null : new InteropTransactionRequestData(interopRequestData);
    }
}

