/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.api;

import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.api.AuthenticationApiResource;
import org.apache.fineract.infrastructure.security.api.AuthenticationApiResourceSwagger;
import org.apache.fineract.infrastructure.security.data.AuthenticatedUserData;
import org.apache.fineract.infrastructure.security.service.SpringSecurityPlatformSecurityContext;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.useradministration.data.RoleData;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.domain.Role;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"fineract.security.basicauth.enabled"})
@Path(value="/v1/authentication")
@Tag(name="Authentication HTTP Basic", description="An API capability that allows client applications to verify authentication details using HTTP Basic Authentication.")
public class AuthenticationApiResource {
    @Value(value="${fineract.security.2fa.enabled}")
    private boolean twoFactorEnabled;
    @Qualifier(value="customAuthenticationProvider")
    private final DaoAuthenticationProvider customAuthenticationProvider;
    private final ToApiJsonSerializer<AuthenticatedUserData> apiJsonSerializerService;
    private final SpringSecurityPlatformSecurityContext springSecurityPlatformSecurityContext;
    private final ClientReadPlatformService clientReadPlatformService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Verify authentication", description="Authenticates the credentials provided and returns the set roles and permissions allowed.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=AuthenticationApiResourceSwagger.PostAuthenticationRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AuthenticationApiResourceSwagger.PostAuthenticationResponse.class))}), @ApiResponse(responseCode="400", description="Unauthenticated. Please login")})
    public String authenticate(@Parameter(hidden=true) String apiRequestBodyAsJson, @QueryParam(value="returnClientList") @DefaultValue(value="false") boolean returnClientList) {
        AuthenticateRequest request = (AuthenticateRequest)new Gson().fromJson(apiRequestBodyAsJson, AuthenticateRequest.class);
        if (request == null) {
            throw new IllegalArgumentException("Invalid JSON in BODY (no longer URL param; see FINERACT-726) of POST to /authentication: " + apiRequestBodyAsJson);
        }
        if (request.username == null || request.password == null) {
            throw new IllegalArgumentException("Username or Password is null in JSON (see FINERACT-726) of POST to /authentication: " + apiRequestBodyAsJson + "; username=" + request.username + ", password=" + request.password);
        }
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)request.username, (Object)request.password);
        Authentication authenticationCheck = this.customAuthenticationProvider.authenticate((Authentication)authentication);
        ArrayList<String> permissions = new ArrayList<String>();
        AuthenticatedUserData authenticatedUserData = new AuthenticatedUserData().setUsername(request.username).setPermissions(permissions);
        if (authenticationCheck.isAuthenticated()) {
            ArrayList authorities = new ArrayList(authenticationCheck.getAuthorities());
            for (GrantedAuthority grantedAuthority : authorities) {
                permissions.add(grantedAuthority.getAuthority());
            }
            byte[] base64EncodedAuthenticationKey = Base64.getEncoder().encode((request.username + ":" + request.password).getBytes(StandardCharsets.UTF_8));
            AppUser principal = (AppUser)authenticationCheck.getPrincipal();
            ArrayList<RoleData> roles = new ArrayList<RoleData>();
            Set userRoles = principal.getRoles();
            for (Role role : userRoles) {
                roles.add(role.toData());
            }
            Long officeId = (Long)principal.getOffice().getId();
            String officeName = principal.getOffice().getName();
            Long staffId = principal.getStaffId();
            String staffDisplayName = principal.getStaffDisplayName();
            EnumOptionData organisationalRole = principal.organisationalRoleData();
            boolean isTwoFactorRequired = this.twoFactorEnabled && !principal.hasSpecificPermissionTo("BYPASS_TWOFACTOR");
            Long userId = (Long)principal.getId();
            authenticatedUserData = this.springSecurityPlatformSecurityContext.doesPasswordHasToBeRenewed(principal) ? new AuthenticatedUserData().setUsername(request.username).setUserId(userId).setBase64EncodedAuthenticationKey(new String(base64EncodedAuthenticationKey, StandardCharsets.UTF_8)).setAuthenticated(true).setShouldRenewPassword(true).setTwoFactorAuthenticationRequired(isTwoFactorRequired) : new AuthenticatedUserData().setUsername(request.username).setOfficeId(officeId).setOfficeName(officeName).setStaffId(staffId).setStaffDisplayName(staffDisplayName).setOrganisationalRole(organisationalRole).setRoles(roles).setPermissions(permissions).setUserId((Long)principal.getId()).setAuthenticated(true).setBase64EncodedAuthenticationKey(new String(base64EncodedAuthenticationKey, StandardCharsets.UTF_8)).setTwoFactorAuthenticationRequired(isTwoFactorRequired).setClients(returnClientList ? this.clientReadPlatformService.retrieveUserClients(userId) : null);
        }
        return this.apiJsonSerializerService.serialize((Object)authenticatedUserData);
    }

    @Generated
    public AuthenticationApiResource(@Qualifier(value="customAuthenticationProvider") DaoAuthenticationProvider customAuthenticationProvider, ToApiJsonSerializer<AuthenticatedUserData> apiJsonSerializerService, SpringSecurityPlatformSecurityContext springSecurityPlatformSecurityContext, ClientReadPlatformService clientReadPlatformService) {
        this.customAuthenticationProvider = customAuthenticationProvider;
        this.apiJsonSerializerService = apiJsonSerializerService;
        this.springSecurityPlatformSecurityContext = springSecurityPlatformSecurityContext;
        this.clientReadPlatformService = clientReadPlatformService;
    }
}

