/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service.updatenpa;

import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.core.service.database.DatabaseTypeResolver;
import org.apache.fineract.infrastructure.core.service.database.RoutingDataSourceServiceFactory;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.jdbc.core.JdbcTemplate;

public class UpdateNpaTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateNpaTasklet.class);
    private final RoutingDataSourceServiceFactory dataSourceServiceFactory;
    private final DatabaseTypeResolver databaseTypeResolver;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final PlatformSecurityContext context;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        AppUser user = this.context.getAuthenticatedUserIfPresent();
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSourceServiceFactory.determineDataSourceService().retrieveDataSource());
        StringBuilder resetNPASqlBuilder = new StringBuilder();
        resetNPASqlBuilder.append("update m_loan loan ");
        Object fromPart = " (SELECT loan2.* FROM m_loan loan2 left join m_loan_arrears_aging laa on laa.loan_id = loan2.id inner join m_product_loan mpl on mpl.id = loan2.product_id and mpl.overdue_days_for_npa is not null WHERE loan2.loan_status_id = 300 and mpl.account_moves_out_of_npa_only_on_arrears_completion = false or (mpl.account_moves_out_of_npa_only_on_arrears_completion = true and laa.overdue_since_date_derived is null)) sl";
        String wherePart = " where loan.id = sl.id ";
        if (this.databaseTypeResolver.isMySQL()) {
            resetNPASqlBuilder.append(", ").append((String)fromPart).append(" set loan.is_npa = false").append(", loan.last_modified_by = ?, loan.last_modified_on_utc = ? ").append(wherePart);
        } else {
            resetNPASqlBuilder.append("set is_npa = false").append(", last_modified_by = ?, last_modified_on_utc = ? ").append(" FROM ").append((String)fromPart).append(wherePart);
        }
        jdbcTemplate.update(resetNPASqlBuilder.toString(), new Object[]{user.getId(), DateUtils.getAuditOffsetDateTime()});
        StringBuilder updateSqlBuilder = new StringBuilder(900);
        fromPart = " (select loan.id  FROM m_loan_arrears_aging laa INNER JOIN  m_loan loan on laa.loan_id = loan.id  INNER JOIN m_product_loan mpl on mpl.id = loan.product_id AND mpl.overdue_days_for_npa is not null WHERE loan.loan_status_id = 300 and laa.overdue_since_date_derived < " + this.sqlGenerator.subDate(this.sqlGenerator.currentBusinessDate(), "COALESCE(mpl.overdue_days_for_npa, 0)", "day") + " group by loan.id) as sl ";
        wherePart = " where ml.id=sl.id ";
        updateSqlBuilder.append("UPDATE m_loan as ml ");
        if (this.databaseTypeResolver.isMySQL()) {
            updateSqlBuilder.append(", ").append((String)fromPart).append(" SET ml.is_npa = true").append(", ml.last_modified_by = ?, ml.last_modified_on_utc = ? ").append(wherePart);
        } else {
            updateSqlBuilder.append(" SET is_npa = true").append(", last_modified_by = ?, last_modified_on_utc = ? ").append(" FROM ").append((String)fromPart).append(wherePart);
        }
        int result = jdbcTemplate.update(updateSqlBuilder.toString(), new Object[]{user.getId(), DateUtils.getAuditOffsetDateTime()});
        log.debug("{}: Records affected by updateNPA: {}", (Object)ThreadLocalContextUtil.getTenant().getName(), (Object)result);
        return RepeatStatus.FINISHED;
    }

    @Generated
    public UpdateNpaTasklet(RoutingDataSourceServiceFactory dataSourceServiceFactory, DatabaseTypeResolver databaseTypeResolver, DatabaseSpecificSQLGenerator sqlGenerator, PlatformSecurityContext context) {
        this.dataSourceServiceFactory = dataSourceServiceFactory;
        this.databaseTypeResolver = databaseTypeResolver;
        this.sqlGenerator = sqlGenerator;
        this.context = context;
    }
}

