/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.batch.command.internal;

import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.batch.command.CommandStrategy;
import org.apache.fineract.batch.command.CommandStrategyUtils;
import org.apache.fineract.batch.domain.BatchRequest;
import org.apache.fineract.batch.domain.BatchResponse;
import org.apache.fineract.infrastructure.core.api.MutableUriInfo;
import org.apache.fineract.infrastructure.dataqueries.api.DatatablesApiResource;
import org.springframework.stereotype.Component;

@Component
public class GetDatatableEntryByAppTableIdCommandStrategy
implements CommandStrategy {
    private final DatatablesApiResource dataTablesApiResource;

    public BatchResponse execute(BatchRequest request, UriInfo uriInfo) {
        long appTableId;
        MutableUriInfo parameterizedUriInfo = new MutableUriInfo(uriInfo);
        BatchResponse response = new BatchResponse();
        response.setRequestId(request.getRequestId());
        response.setHeaders(request.getHeaders());
        String relativeUrl = CommandStrategyUtils.relativeUrlWithoutVersion((BatchRequest)request);
        String relativeUrlSubString = StringUtils.substringAfter((String)relativeUrl, (String)"/");
        if (relativeUrl.indexOf(63) > 0) {
            appTableId = Long.parseLong(StringUtils.substringBetween((String)relativeUrlSubString, (String)"/", (String)"?"));
            Map queryParameters = CommandStrategyUtils.getQueryParameters((String)relativeUrl);
            CommandStrategyUtils.addQueryParametersToUriInfo((MutableUriInfo)parameterizedUriInfo, (Map)queryParameters);
        } else {
            appTableId = Long.parseLong(StringUtils.substringAfter((String)relativeUrlSubString, (String)"/"));
        }
        String dataTableName = relativeUrlSubString.substring(0, relativeUrlSubString.indexOf("/"));
        String responseBody = this.dataTablesApiResource.getDatatable(dataTableName, Long.valueOf(appTableId), null, (UriInfo)parameterizedUriInfo);
        response.setStatusCode(Integer.valueOf(200));
        response.setBody(responseBody);
        return response;
    }

    @Generated
    public GetDatatableEntryByAppTableIdCommandStrategy(DatatablesApiResource dataTablesApiResource) {
        this.dataTablesApiResource = dataTablesApiResource;
    }
}

