/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;

public final class ResourceUtils {
    private ResourceUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static Path writeResourceToPath(ClassLoader classLoader, Path destinationPath, String resourceName) {
        try {
            Path resourcePath = destinationPath.resolve(resourceName);
            Files.createDirectories(resourcePath.getParent(), new FileAttribute[0]);
            try (InputStream inputStream = classLoader.getResourceAsStream(resourceName);
                 OutputStream outputStream = Files.newOutputStream(resourcePath, new OpenOption[0]);){
                int length;
                Assertions.assertThat((InputStream)inputStream).isNotNull();
                byte[] buffer = new byte[1024];
                while ((length = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, length);
                }
            }
            return resourcePath;
        }
        catch (IOException exception) {
            String failureMessage = "Unable to create resource " + resourceName;
            Assertions.fail((String)failureMessage, (Throwable)exception);
            throw new RuntimeException(failureMessage, exception);
        }
    }
}

