/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.token;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.RingInstanceTest;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CassandraClusterInfoGroup;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedWriteConf;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.bulkwriter.token.FailureHandlerTextContext;
import org.apache.cassandra.spark.bulkwriter.token.MultiClusterReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.ReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMappingTest;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class MultiClusterReplicaAwareFailureHandlerTest {
    private static final String DATACENTER_1 = "dc1";
    private final Partitioner partitioner = Partitioner.Murmur3Partitioner;
    private MultiClusterReplicaAwareFailureHandler<RingInstance> handler = new MultiClusterReplicaAwareFailureHandler(this.partitioner);

    MultiClusterReplicaAwareFailureHandlerTest() {
    }

    @Test
    void testAddFailuresFromBothInstancesWithAndWithoutClusterIdFails() {
        RingInstance instance = RingInstanceTest.instance(BigInteger.valueOf(10L), "node1", DATACENTER_1);
        RingInstance instanceWithClusterId = new RingInstance(instance.ringEntry(), "testCluster");
        Assertions.assertThatNoException().isThrownBy(() -> this.handler.addFailure(TestUtils.range(0L, 10L), (CassandraInstance)instance, "failure"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.handler.addFailure(TestUtils.range(0L, 10L), (CassandraInstance)instanceWithClusterId, "failure")).isExactlyInstanceOf(IllegalStateException.class)).hasMessage("Cannot set value for non-null cluster when the container is used for non-coordinated-write");
        this.handler = new MultiClusterReplicaAwareFailureHandler(this.partitioner);
        Assertions.assertThatNoException().isThrownBy(() -> this.handler.addFailure(TestUtils.range(0L, 10L), (CassandraInstance)instanceWithClusterId, "failure"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.handler.addFailure(TestUtils.range(0L, 10L), (CassandraInstance)instance, "failure")).isExactlyInstanceOf(IllegalStateException.class)).hasMessage("Cannot set value for null cluster when the container is used for coordinated-write");
    }

    @Test
    void testGetFailedInstanceFromMultipleClusters() {
        RingInstance instanceC1 = RingInstanceTest.instance(BigInteger.ZERO, "node1", DATACENTER_1, "cluster1");
        RingInstance instanceC2 = RingInstanceTest.instance(BigInteger.ZERO, "node1", DATACENTER_1, "cluster2");
        this.handler.addFailure(TestUtils.range(-10L, 0L), (CassandraInstance)instanceC1, "failure in cluster1 instance");
        this.handler.addFailure(TestUtils.range(-10L, 0L), (CassandraInstance)instanceC2, "failure in cluster2 instance");
        Set failedInstances = this.handler.getFailedInstances();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)failedInstances).hasSize(2)).containsExactlyInAnyOrder((Object[])new RingInstance[]{instanceC1, instanceC2});
    }

    @Test
    void testGetFailedRangesOfClusters() {
        this.testFailedRangeCheckWithTwoClusters(ctx -> {
            Range<BigInteger> range = TestUtils.range(1L, 10L);
            Map writeReplicasOfRangeAcrossClusters = ctx.topology.getWriteReplicasOfRange(range, DATACENTER_1);
            Assertions.assertThat((Map)writeReplicasOfRangeAcrossClusters).hasSize(1);
            Map<String, List<RingInstance>> writeReplicasPerCluster = writeReplicasOfRangeAcrossClusters.values().stream().flatMap(Collection::stream).collect(Collectors.groupingBy(RingInstance::clusterId));
            ((MapAssert)Assertions.assertThat(writeReplicasPerCluster).hasSize(2)).containsKeys((Object[])new String[]{"cluster1", "cluster2"});
            this.handler.addFailure(range, (CassandraInstance)writeReplicasPerCluster.get("cluster1").get(0), "failure in cluster1");
            this.handler.addFailure(range, (CassandraInstance)writeReplicasPerCluster.get("cluster2").get(0), "failure in cluster2");
            ((ListAssert)Assertions.assertThat((List)this.handler.getFailedRanges(ctx.topology, ctx.jobInfo, ctx.clusterInfo)).describedAs("Each cluster should have only 1 failure of the range, which is acceptable for LOCAL_QUORUM.", new Object[0])).isEmpty();
            this.handler.addFailure(range, (CassandraInstance)writeReplicasPerCluster.get("cluster1").get(1), "another failure in cluster1");
            List failedRanges = this.handler.getFailedRanges(ctx.topology, ctx.jobInfo, ctx.clusterInfo);
            ((ListAssert)Assertions.assertThat((List)failedRanges).describedAs("Cluster1 should have failed range", new Object[0])).hasSize(1);
            Set failedInstances = ((ReplicaAwareFailureHandler.ConsistencyFailurePerRange)failedRanges.get((int)0)).failuresPerInstance.instances();
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)failedInstances).hasSize(2)).containsExactlyInAnyOrder((Object[])new RingInstance[]{writeReplicasPerCluster.get("cluster1").get(0), writeReplicasPerCluster.get("cluster1").get(1)});
            this.handler.addFailure(range, (CassandraInstance)writeReplicasPerCluster.get("cluster2").get(1), "another failure in cluster2");
            failedRanges = this.handler.getFailedRanges(ctx.topology, ctx.jobInfo, ctx.clusterInfo);
            ((ListAssert)Assertions.assertThat((List)failedRanges).describedAs("Both clusters should have failed ranges", new Object[0])).hasSize(2);
            Set failedInstancesInCluster2 = ((ReplicaAwareFailureHandler.ConsistencyFailurePerRange)failedRanges.get((int)1)).failuresPerInstance.instances();
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)failedInstancesInCluster2).hasSize(2)).containsExactlyInAnyOrder((Object[])new RingInstance[]{writeReplicasPerCluster.get("cluster2").get(0), writeReplicasPerCluster.get("cluster2").get(1)});
        });
    }

    private void testFailedRangeCheckWithTwoClusters(Consumer<FailureHandlerTextContext> test) {
        TokenRangeMapping<RingInstance> cluster1Topology = TokenRangeMappingTest.createTestMapping(0L, 5, this.partitioner, "cluster1");
        TokenRangeMapping<RingInstance> cluster2Topology = TokenRangeMappingTest.createTestMapping(1L, 5, this.partitioner, "cluster2");
        TokenRangeMapping consolidatedTopology = TokenRangeMapping.consolidate(Arrays.asList(cluster1Topology, cluster2Topology));
        JobInfo jobInfo = (JobInfo)Mockito.mock(JobInfo.class);
        Mockito.when((Object)jobInfo.getConsistencyLevel()).thenReturn((Object)ConsistencyLevel.CL.LOCAL_QUORUM);
        CoordinatedWriteConf cwc = (CoordinatedWriteConf)Mockito.mock(CoordinatedWriteConf.class);
        CoordinatedWriteConf.ClusterConf cc = (CoordinatedWriteConf.ClusterConf)Mockito.mock(CoordinatedWriteConf.ClusterConf.class);
        Mockito.when((Object)cc.localDc()).thenReturn((Object)DATACENTER_1);
        Mockito.when((Object)cwc.cluster((String)ArgumentMatchers.any())).thenReturn((Object)cc);
        Mockito.when((Object)jobInfo.coordinatedWriteConf()).thenReturn((Object)cwc);
        Mockito.when((Object)jobInfo.isCoordinatedWriteEnabled()).thenReturn((Object)true);
        CassandraClusterInfoGroup group = (CassandraClusterInfoGroup)Mockito.mock(CassandraClusterInfoGroup.class);
        ReplicationFactor rf = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)DATACENTER_1, (Object)3));
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Mockito.when((Object)clusterInfo.replicationFactor()).thenReturn((Object)rf);
        Mockito.when((Object)((ClusterInfo)group.getValueOrThrow((String)ArgumentMatchers.any()))).thenReturn((Object)clusterInfo);
        test.accept(new FailureHandlerTextContext((TokenRangeMapping<RingInstance>)consolidatedTopology, jobInfo, (ClusterInfo)group));
    }
}

