/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.Random;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.DataChunker;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataChunkerTest {
    @Test
    public void testChunksGeneratedWithWholeChunks() throws IOException {
        this.testChunking(512, 4, 128);
    }

    @Test
    public void testChunksGeneratedWithSmallerLastChunk() throws IOException {
        this.testChunking(513, 4, 129);
    }

    private void testChunking(int totalSize, int chunkSize, int expectedChunks) throws IOException {
        DataChunker chunker = new DataChunker(chunkSize, false);
        Random rd = new Random();
        byte[] expected = new byte[totalSize];
        rd.nextBytes(expected);
        try (ReadableByteChannel channel = Channels.newChannel(new ByteArrayInputStream(expected));){
            int size = 0;
            Iterator chunks = chunker.chunks(channel);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while (chunks.hasNext()) {
                ByteBuffer buffer = (ByteBuffer)chunks.next();
                bos.write(ByteBufferUtils.getArray((ByteBuffer)buffer));
                ++size;
            }
            Assertions.assertThat((int)size).isEqualTo(expectedChunks);
            Assertions.assertThat((byte[])bos.toByteArray()).isEqualTo((Object)expected);
        }
    }
}

