/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.benchmarks;

import java.nio.ByteBuffer;
import org.apache.cassandra.spark.bulkwriter.util.FastByteOperations;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@Warmup(iterations=2)
@Measurement(iterations=3)
@BenchmarkMode(value={Mode.Throughput})
@State(value=Scope.Thread)
public class ByteOperationsBenchmark {
    @Param(value={"1", "10", "100", "1000"})
    int numBytes;
    ByteBuffer bytes1;
    ByteBuffer bytes2;
    FastByteOperations.PureJavaOperations pureJavaOperations = new FastByteOperations.PureJavaOperations();
    FastByteOperations.UnsafeOperations unsafeOperations = new FastByteOperations.UnsafeOperations();

    @Setup(value=Level.Trial)
    public void setup() {
        byte[] bytes = RandomUtils.randomBytes((int)this.numBytes);
        this.bytes1 = ByteBuffer.wrap((byte[])bytes.clone());
        this.bytes2 = ByteBuffer.wrap((byte[])bytes.clone());
    }

    @Benchmark
    public int unsafeImplementation() {
        this.bytes1.position(0);
        this.bytes2.position(0);
        int result = this.unsafeOperations.compare(this.bytes1, this.bytes2);
        assert (0 == result) : "Failed to compare";
        return result;
    }

    @Benchmark
    public int javaImplementation() {
        this.bytes1.position(0);
        this.bytes2.position(0);
        int result = this.pureJavaOperations.compare(this.bytes1, this.bytes2);
        assert (result == 0) : "Failed to compare";
        return result;
    }
}

