/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.request;

import io.netty.handler.codec.http.HttpMethod;
import org.apache.cassandra.sidecar.common.request.Request;
import org.apache.cassandra.sidecar.common.response.ListSnapshotFilesResponse;
import org.apache.cassandra.sidecar.common.utils.HttpRange;

public class SSTableComponentRequest
extends Request {
    private final HttpRange range;

    public SSTableComponentRequest(String keyspace, String tableName, String snapshotName, String componentName, HttpRange range) {
        super(SSTableComponentRequest.requestURI(keyspace, tableName, snapshotName, componentName));
        this.range = range;
    }

    public SSTableComponentRequest(ListSnapshotFilesResponse.FileInfo fileInfo, HttpRange range) {
        super(fileInfo.componentDownloadUrl());
        this.range = range;
    }

    @Override
    protected HttpRange range() {
        return this.range;
    }

    @Override
    public HttpMethod method() {
        return HttpMethod.GET;
    }

    @Override
    public String toString() {
        return "SSTableComponentRequest{range=" + String.valueOf(this.range) + ", requestURI='" + this.requestURI + "'}";
    }

    static String requestURI(String keyspace, String table, String snapshot, String component) {
        return "/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot/components/:component".replaceAll(":keyspace", keyspace).replaceAll(":table", table).replaceAll(":snapshot", snapshot).replaceAll(":component", component);
    }
}

