/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.testing;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.sidecar.testing.QualifiedName;

public final class TestUtils {
    public static final String TEST_KEYSPACE = "spark_test";
    public static final String TEST_TABLE_PREFIX = "testtable";
    private static final AtomicInteger TEST_TABLE_ID = new AtomicInteger(0);
    public static final int ROW_COUNT = 1000;
    public static final Map<String, Integer> DC1_RF1 = Collections.singletonMap("datacenter1", 1);
    public static final Map<String, Integer> DC1_RF3 = Collections.singletonMap("datacenter1", 3);
    public static final Map<String, Integer> DC1_RF2_DC2_RF2 = ImmutableMap.of((Object)"datacenter1", (Object)2, (Object)"datacenter2", (Object)2);
    public static final Map<String, Integer> DC1_RF3_DC2_RF3 = ImmutableMap.of((Object)"datacenter1", (Object)3, (Object)"datacenter2", (Object)3);
    public static final String CREATE_TEST_TABLE_STATEMENT = "CREATE TABLE IF NOT EXISTS %s (id int, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';";

    private TestUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static QualifiedName uniqueTestTableFullName(String keyspace) {
        return TestUtils.uniqueTestTableFullName(keyspace, TEST_TABLE_PREFIX);
    }

    public static QualifiedName uniqueTestTableFullName(String keyspace, String testTablePrefix) {
        return new QualifiedName(keyspace, testTablePrefix + TEST_TABLE_ID.getAndIncrement());
    }

    public static QualifiedName uniqueTestQuotedKeyspaceQuotedTableFullName(String keyspace, String tablePrefix) {
        return new QualifiedName(keyspace, tablePrefix + TEST_TABLE_ID.getAndIncrement(), true, true);
    }

    public static QualifiedName uniqueTestKeyspaceQuotedTableFullName(String keyspace, String tablePrefix) {
        return new QualifiedName(keyspace, tablePrefix + TEST_TABLE_ID.getAndIncrement(), false, true);
    }

    public static QualifiedName uniqueTestQuotedKeyspaceTableFullName(String keyspace) {
        return new QualifiedName(keyspace, TEST_TABLE_PREFIX + TEST_TABLE_ID.getAndIncrement(), true, false);
    }

    public static void configureDefaultDTestJarProperties() {
        System.setProperty("cassandra.ring_delay_ms", "5000");
        System.setProperty("cassandra.consistent.rangemovement", "false");
        System.setProperty("cassandra.consistent.simultaneousmoves.allow", "true");
        System.setProperty("cassandra.test.dtest_jar_path", System.getProperty("cassandra.test.dtest_jar_path", "dependencies"));
        System.setProperty("cassandra.disable_tcactive_openssl", "true");
        System.setProperty("cassandra.gossip_settle_min_wait_ms", "500");
        System.setProperty("cassandra.gossip_settle_interval_ms", "250");
        System.setProperty("cassandra.gossip_settle_poll_success_required", "6");
        System.setProperty("cassandra.netty_use_heap_allocator", "true");
        System.setProperty("cassandra.require_native_file_hints", "true");
        System.setProperty("shaded.io.netty.transport.noNative", "true");
        System.setProperty("cassandra.allow_alter_rf_during_range_movement", "true");
        System.setProperty("cassandra.minimum_replication_factor", "1");
    }
}

