/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.testing;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.distributed.api.TokenSupplier;
import org.apache.cassandra.testing.Partitioner;

public class TestTokenSupplier {
    protected TestTokenSupplier() {
        throw new UnsupportedOperationException();
    }

    public static TokenSupplier evenlyDistributedTokens(int numNodesPerDC, int newNodesPerDC, int numDcs, int numTokensPerNode) {
        return TestTokenSupplier.evenlyDistributedTokens(Partitioner.Murmur3, numNodesPerDC, newNodesPerDC, numDcs, numTokensPerNode);
    }

    public static TokenSupplier evenlyDistributedTokens(Partitioner partitioner, int numNodesPerDC, int newNodesPerDC, int numDcs, int numTokensPerNode) {
        long totalTokens = (long)numNodesPerDC * (long)numDcs * (long)numTokensPerNode;
        BigInteger increment = partitioner.maxToken.subtract(partitioner.minToken.add(BigInteger.ONE)).multiply(BigInteger.valueOf(numDcs)).divide(BigInteger.valueOf(totalTokens + 2L));
        List[] tokens = TestTokenSupplier.allocateExistingNodeTokens(partitioner, numNodesPerDC, newNodesPerDC, numDcs, numTokensPerNode, increment);
        BigInteger value = new BigInteger(tokens[numDcs - 1].get(0));
        BigInteger subIncrement = increment.divide(BigInteger.valueOf(2L));
        int nodeId = (int)totalTokens + 1;
        for (int i = 0; i < numTokensPerNode; ++i) {
            while (nodeId <= (numNodesPerDC + newNodesPerDC) * numDcs) {
                value = value.add(subIncrement);
                for (int dc = 0; dc < numDcs; ++dc) {
                    tokens[nodeId - 1].add(value.add(BigInteger.valueOf(dc)).toString());
                    ++nodeId;
                }
                value = value.add(subIncrement);
            }
        }
        return nodeIdx -> tokens[nodeIdx - 1];
    }

    private static List<String>[] allocateExistingNodeTokens(Partitioner partitioner, int numNodesPerDC, int newNodesPerDC, int numDcs, int numTokensPerNode, BigInteger increment) {
        List[] tokens = new List[(numNodesPerDC + newNodesPerDC) * numDcs * numTokensPerNode];
        Arrays.setAll(tokens, ignored -> new ArrayList(numTokensPerNode));
        BigInteger value = partitioner.minToken.add(BigInteger.ONE);
        for (int i = 0; i < numTokensPerNode; ++i) {
            int nodeId = 1;
            while (nodeId <= numNodesPerDC * numDcs) {
                value = value.add(increment);
                for (int dc = 0; dc < numDcs; ++dc) {
                    tokens[nodeId - 1].add(value.add(BigInteger.valueOf(dc)).toString());
                    ++nodeId;
                }
            }
        }
        return tokens;
    }
}

