/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import org.apache.cassandra.spark.sparksql.Cell;
import org.apache.cassandra.spark.sparksql.RowBuilder;
import org.apache.cassandra.spark.sparksql.RowBuilderDecorator;
import org.apache.spark.sql.catalyst.InternalRow;

public class LastModifiedTimestampDecorator<T extends InternalRow>
extends RowBuilderDecorator<T> {
    private final int lmtColumnPosition;
    private long lastModified = 0L;

    public LastModifiedTimestampDecorator(RowBuilder<T> delegate, String fieldName) {
        super(delegate);
        int width = this.internalExpandRow();
        int fieldIndex = this.fieldIndex(fieldName);
        this.lmtColumnPosition = fieldIndex >= 0 ? fieldIndex : width;
    }

    @Override
    public void reset() {
        super.reset();
        this.lastModified = 0L;
    }

    @Override
    public void onCell(Cell cell) {
        super.onCell(cell);
        this.lastModified = Math.max(this.lastModified, cell.timestamp);
    }

    @Override
    protected int extraColumns() {
        return 1;
    }

    @Override
    public T build() {
        Object[] result = this.array();
        result[this.lmtColumnPosition] = this.lastModified;
        return super.build();
    }
}

