/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class MurmurHash {
    public static int hash32(ByteBuffer data, int offset, int length, int seed) {
        int m3 = 1540483477;
        int r = 24;
        int h2 = seed ^ length;
        int len_4 = length >> 2;
        for (int i = 0; i < len_4; ++i) {
            int i_4 = i << 2;
            int k = data.get(offset + i_4 + 3);
            k <<= 8;
            k |= data.get(offset + i_4 + 2) & 0xFF;
            k <<= 8;
            k |= data.get(offset + i_4 + 1) & 0xFF;
            k <<= 8;
            k |= data.get(offset + i_4 + 0) & 0xFF;
            k *= m3;
            k ^= k >>> r;
            h2 *= m3;
            h2 ^= (k *= m3);
        }
        int len_m = len_4 << 2;
        int left = length - len_m;
        if (left != 0) {
            if (left >= 3) {
                h2 ^= data.get(offset + length - 3) << 16;
            }
            if (left >= 2) {
                h2 ^= data.get(offset + length - 2) << 8;
            }
            if (left >= 1) {
                h2 ^= data.get(offset + length - 1);
            }
            h2 *= m3;
        }
        h2 ^= h2 >>> 13;
        h2 *= m3;
        h2 ^= h2 >>> 15;
        return h2;
    }

    public static long hash2_64(ByteBuffer key, int offset, int length, long seed) {
        long m64 = -4132994306676758123L;
        int r64 = 47;
        long h64 = seed & 0xFFFFFFFFL ^ m64 * (long)length;
        int lenLongs = length >> 3;
        for (int i = 0; i < lenLongs; ++i) {
            int i_8 = i << 3;
            long k64 = ((long)key.get(offset + i_8 + 0) & 0xFFL) + (((long)key.get(offset + i_8 + 1) & 0xFFL) << 8) + (((long)key.get(offset + i_8 + 2) & 0xFFL) << 16) + (((long)key.get(offset + i_8 + 3) & 0xFFL) << 24) + (((long)key.get(offset + i_8 + 4) & 0xFFL) << 32) + (((long)key.get(offset + i_8 + 5) & 0xFFL) << 40) + (((long)key.get(offset + i_8 + 6) & 0xFFL) << 48) + (((long)key.get(offset + i_8 + 7) & 0xFFL) << 56);
            k64 *= m64;
            k64 ^= k64 >>> r64;
            h64 ^= (k64 *= m64);
            h64 *= m64;
        }
        int rem = length & 7;
        switch (rem) {
            case 0: {
                break;
            }
            case 7: {
                h64 ^= (long)key.get(offset + length - rem + 6) << 48;
            }
            case 6: {
                h64 ^= (long)key.get(offset + length - rem + 5) << 40;
            }
            case 5: {
                h64 ^= (long)key.get(offset + length - rem + 4) << 32;
            }
            case 4: {
                h64 ^= (long)key.get(offset + length - rem + 3) << 24;
            }
            case 3: {
                h64 ^= (long)key.get(offset + length - rem + 2) << 16;
            }
            case 2: {
                h64 ^= (long)key.get(offset + length - rem + 1) << 8;
            }
            case 1: {
                h64 ^= (long)key.get(offset + length - rem);
                h64 *= m64;
            }
        }
        h64 ^= h64 >>> r64;
        h64 *= m64;
        h64 ^= h64 >>> r64;
        return h64;
    }

    protected static long getBlock(ByteBuffer key, int offset, int index) {
        int i_8 = index << 3;
        int blockOffset = offset + i_8;
        return ((long)key.get(blockOffset + 0) & 0xFFL) + (((long)key.get(blockOffset + 1) & 0xFFL) << 8) + (((long)key.get(blockOffset + 2) & 0xFFL) << 16) + (((long)key.get(blockOffset + 3) & 0xFFL) << 24) + (((long)key.get(blockOffset + 4) & 0xFFL) << 32) + (((long)key.get(blockOffset + 5) & 0xFFL) << 40) + (((long)key.get(blockOffset + 6) & 0xFFL) << 48) + (((long)key.get(blockOffset + 7) & 0xFFL) << 56);
    }

    protected static long rotl64(long v, int n) {
        return v << n | v >>> 64 - n;
    }

    protected static long fmix(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public static void hash3_x64_128(ByteBuffer key, int offset, int length, long seed, long[] result) {
        int nblocks = length >> 4;
        long h1 = seed;
        long h2 = seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        for (int i = 0; i < nblocks; ++i) {
            long k1 = MurmurHash.getBlock(key, offset, i * 2 + 0);
            long k2 = MurmurHash.getBlock(key, offset, i * 2 + 1);
            k1 *= c1;
            k1 = MurmurHash.rotl64(k1, 31);
            h1 ^= (k1 *= c2);
            h1 = MurmurHash.rotl64(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= c2;
            k2 = MurmurHash.rotl64(k2, 33);
            h2 ^= (k2 *= c1);
            h2 = MurmurHash.rotl64(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        offset += nblocks * 16;
        long k1 = 0L;
        long k2 = 0L;
        switch (length & 0xF) {
            case 15: {
                k2 ^= (long)key.get(offset + 14) << 48;
            }
            case 14: {
                k2 ^= (long)key.get(offset + 13) << 40;
            }
            case 13: {
                k2 ^= (long)key.get(offset + 12) << 32;
            }
            case 12: {
                k2 ^= (long)key.get(offset + 11) << 24;
            }
            case 11: {
                k2 ^= (long)key.get(offset + 10) << 16;
            }
            case 10: {
                k2 ^= (long)key.get(offset + 9) << 8;
            }
            case 9: {
                k2 ^= (long)key.get(offset + 8) << 0;
                k2 *= c2;
                k2 = MurmurHash.rotl64(k2, 33);
                h2 ^= (k2 *= c1);
            }
            case 8: {
                k1 ^= (long)key.get(offset + 7) << 56;
            }
            case 7: {
                k1 ^= (long)key.get(offset + 6) << 48;
            }
            case 6: {
                k1 ^= (long)key.get(offset + 5) << 40;
            }
            case 5: {
                k1 ^= (long)key.get(offset + 4) << 32;
            }
            case 4: {
                k1 ^= (long)key.get(offset + 3) << 24;
            }
            case 3: {
                k1 ^= (long)key.get(offset + 2) << 16;
            }
            case 2: {
                k1 ^= (long)key.get(offset + 1) << 8;
            }
            case 1: {
                k1 ^= (long)key.get(offset);
                k1 *= c1;
                k1 = MurmurHash.rotl64(k1, 31);
                h1 ^= (k1 *= c2);
            }
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = MurmurHash.fmix(h1);
        h2 = MurmurHash.fmix(h2);
        h1 += h2;
        result[0] = h1;
        result[1] = h2 += h1;
    }

    protected static long invRotl64(long v, int n) {
        return v >>> n | v << 64 - n;
    }

    protected static long invRShiftXor(long value, int shift) {
        long output = 0L;
        long i = 0L;
        while (i * (long)shift < 64L) {
            long c = -1L << 64 - shift >>> (int)((long)shift * i);
            long partOutput = value & c;
            value ^= partOutput >>> shift;
            output |= partOutput;
            ++i;
        }
        return output;
    }

    protected static long invFmix(long k) {
        k = MurmurHash.invRShiftXor(k, 33);
        k *= -7154897129451604005L;
        k = MurmurHash.invRShiftXor(k, 33);
        k *= 5725274745694666757L;
        k = MurmurHash.invRShiftXor(k, 33);
        return k;
    }

    public static long invTailReverse(long num) {
        byte[] v = Longs.toByteArray(Long.reverseBytes(num));
        for (int i = 0; i < 8; ++i) {
            if (v[i] >= 0 || i >= 7) continue;
            BitSet bits = BitSet.valueOf(v);
            bits.flip(8 * (i + 1), 64);
            v = bits.toByteArray();
        }
        return Longs.fromByteArray(v);
    }

    public static long[] inv_hash3_x64_128(long[] result) {
        long c1 = -6231845090142302851L;
        long c2 = -6332601014241317761L;
        long k1 = 0L;
        long k2 = 0L;
        long h1 = result[0];
        long h2 = result[1];
        h2 -= h1;
        h1 -= h2;
        h1 = MurmurHash.invFmix(h1);
        h2 = MurmurHash.invFmix(h2);
        h2 -= h1;
        h1 -= h2;
        h2 ^= 0x10L;
        h2 -= 944331445L;
        h2 *= -3689348814741910323L;
        h2 -= (h1 ^= 0x10L);
        k2 = h2 = MurmurHash.invRotl64(h2, 31);
        h2 = 0L;
        k2 *= c1;
        k2 = MurmurHash.invRotl64(k2, 33);
        k2 *= c2;
        h1 -= 1390208809L;
        h1 *= -3689348814741910323L;
        k1 = h1 = MurmurHash.invRotl64(h1, 27);
        k1 *= c2;
        k1 = MurmurHash.invRotl64(k1, 31);
        k1 *= c1;
        k1 = Long.reverseBytes(k1);
        k2 = Long.reverseBytes(k2);
        return new long[]{k1, k2};
    }
}

