/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.Arrays;
import org.apache.cassandra.utils.EstimatedHistogram;

public class HistogramBuilder {
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final long[] ZERO = new long[]{0L};
    private long[] values = new long[10];
    int count = 0;

    public HistogramBuilder() {
    }

    public HistogramBuilder(long[] values) {
        for (long value : values) {
            this.add(value);
        }
    }

    public void add(long value) {
        if (this.count == this.values.length) {
            this.values = Arrays.copyOf(this.values, this.values.length << 1);
        }
        this.values[this.count++] = value;
    }

    public EstimatedHistogram buildWithStdevRangesAroundMean() {
        return this.buildWithStdevRangesAroundMean(3);
    }

    public EstimatedHistogram buildWithStdevRangesAroundMean(int maxdevs) {
        if (maxdevs < 0) {
            throw new IllegalArgumentException("maxdevs must be greater than or equal to zero");
        }
        int count = this.count;
        long[] values = this.values;
        if (count == 0) {
            return new EstimatedHistogram(EMPTY_LONG_ARRAY, ZERO);
        }
        long min2 = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        double sum = 0.0;
        double sumsq = 0.0;
        for (int i = 0; i < count; ++i) {
            long value = values[i];
            sum += (double)value;
            sumsq += (double)(value * value);
            if (value < min2) {
                min2 = value;
            }
            if (value <= max) continue;
            max = value;
        }
        long mean = Math.round(sum / (double)count);
        double stdev = Math.sqrt(sumsq / (double)count - (double)mean * (double)mean);
        long[] lowhalf = HistogramBuilder.buildRange(mean, min2, true, stdev, maxdevs);
        long[] highhalf = HistogramBuilder.buildRange(mean, max, false, stdev, maxdevs);
        long[] ranges = new long[lowhalf.length + highhalf.length + 1];
        System.arraycopy(lowhalf, 0, ranges, 0, lowhalf.length);
        ranges[lowhalf.length] = mean;
        System.arraycopy(highhalf, 0, ranges, lowhalf.length + 1, highhalf.length);
        EstimatedHistogram hist = new EstimatedHistogram(ranges, new long[ranges.length + 1]);
        for (int i = 0; i < count; ++i) {
            hist.add(values[i]);
        }
        return hist;
    }

    private static long[] buildRange(long mean, long minormax, boolean ismin, double stdev, int maxdevs) {
        long smaller;
        long larger;
        if (minormax == mean) {
            long[] lArray;
            if (ismin) {
                long[] lArray2 = new long[1];
                lArray = lArray2;
                lArray2[0] = mean - 1L;
            } else {
                lArray = EMPTY_LONG_ARRAY;
            }
            return lArray;
        }
        if (stdev < 1.0) {
            long[] lArray;
            if (ismin) {
                long[] lArray3 = new long[2];
                lArray3[0] = minormax - 1L;
                lArray = lArray3;
                lArray3[1] = mean - 1L;
            } else {
                long[] lArray4 = new long[1];
                lArray = lArray4;
                lArray4[0] = minormax;
            }
            return lArray;
        }
        if (ismin) {
            larger = mean;
            smaller = minormax;
        } else {
            larger = minormax;
            smaller = mean;
        }
        double stdevsTo = (double)(larger - smaller) / stdev;
        stdevsTo = stdevsTo > 0.0 && stdevsTo < 1.0 ? 1.0 : (double)Math.round(stdevsTo);
        int len = Math.min(maxdevs + 1, (int)stdevsTo);
        long[] range = new long[len];
        long next = ismin ? minormax - 1L : minormax;
        for (int i = 0; i < range.length; ++i) {
            long delta = (long)(range.length - (i + 1)) * (long)stdev;
            if (ismin) {
                range[i] = next;
                next = mean - delta;
                continue;
            }
            range[len - 1 - i] = next;
            next = mean + delta;
        }
        return range;
    }
}

