/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool.stats;

import com.google.common.collect.Multimap;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.tools.nodetool.formatter.TableBuilder;
import org.apache.cassandra.tools.nodetool.stats.StatsPrinter;
import org.apache.cassandra.tools.nodetool.stats.TpStatsHolder;

public class TpStatsPrinter {
    public static StatsPrinter from(String format) {
        switch (format) {
            case "json": {
                return new StatsPrinter.JsonPrinter();
            }
            case "yaml": {
                return new StatsPrinter.YamlPrinter();
            }
        }
        return new DefaultPrinter();
    }

    public static class DefaultPrinter
    implements StatsPrinter<TpStatsHolder> {
        @Override
        public void print(TpStatsHolder data, PrintStream out) {
            TableBuilder poolBuilder = new TableBuilder();
            poolBuilder.add("Pool Name", "Active", "Pending", "Completed", "Blocked", "All time blocked");
            Multimap<String, String> threadPools = data.probe.getThreadPools();
            for (Map.Entry<String, String> tpool : threadPools.entries()) {
                poolBuilder.add(tpool.getValue(), data.probe.getThreadPoolMetric(tpool.getKey(), tpool.getValue(), "ActiveTasks").toString(), data.probe.getThreadPoolMetric(tpool.getKey(), tpool.getValue(), "PendingTasks").toString(), data.probe.getThreadPoolMetric(tpool.getKey(), tpool.getValue(), "CompletedTasks").toString(), data.probe.getThreadPoolMetric(tpool.getKey(), tpool.getValue(), "CurrentlyBlockedTasks").toString(), data.probe.getThreadPoolMetric(tpool.getKey(), tpool.getValue(), "TotalBlockedTasks").toString());
            }
            poolBuilder.printTo(out);
            out.println("\nLatencies waiting in queue (micros) per dropped message types");
            TableBuilder droppedBuilder = new TableBuilder();
            droppedBuilder.add("Message type", "Dropped    ", "50%     ", "95%     ", "99%     ", "Max");
            HashMap<String, Integer> droppedMessage = new HashMap<String, Integer>();
            HashMap<String, Double[]> waitLatencies = new HashMap<String, Double[]>();
            for (Map.Entry<String, Integer> entry : data.probe.getDroppedMessages().entrySet()) {
                droppedMessage.put(entry.getKey(), entry.getValue());
                try {
                    waitLatencies.put(entry.getKey(), data.probe.metricPercentilesAsArray(data.probe.getMessagingQueueWaitMetrics(entry.getKey())));
                }
                catch (RuntimeException runtimeException) {}
            }
            for (Map.Entry<String, Integer> entry : droppedMessage.entrySet()) {
                List<String> columns = Stream.of(entry.getKey(), ((Object)entry.getValue()).toString()).collect(Collectors.toList());
                if (waitLatencies.containsKey(entry.getKey())) {
                    Double[] latencies = (Double[])waitLatencies.get(entry.getKey());
                    columns.addAll(Arrays.asList(latencies[0].toString(), latencies[2].toString(), latencies[4].toString(), latencies[6].toString()));
                } else {
                    columns.addAll(Arrays.asList("N/A", "N/A", "N/A", "N/A"));
                }
                droppedBuilder.add(columns.toArray(new String[0]));
            }
            droppedBuilder.printTo(out);
        }
    }
}

