/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.disk;

import com.carrotsearch.hppc.LongSet;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.SortedMap;
import org.apache.cassandra.index.sasi.disk.AbstractTokenTreeBuilder;
import org.apache.cassandra.index.sasi.disk.Token;
import org.apache.cassandra.index.sasi.utils.CombinedTerm;
import org.apache.cassandra.index.sasi.utils.RangeIterator;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.Pair;

public class StaticTokenTreeBuilder
extends AbstractTokenTreeBuilder {
    private final CombinedTerm combinedTerm;

    public StaticTokenTreeBuilder(CombinedTerm term) {
        this.combinedTerm = term;
    }

    @Override
    public void add(Long token, long keyPosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(SortedMap<Long, LongSet> data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Iterator<Pair<Long, LongSet>> data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.tokenCount == 0L;
    }

    @Override
    public Iterator<Pair<Long, LongSet>> iterator() {
        final RangeIterator<Long, Token> iterator = this.combinedTerm.getTokenIterator();
        return new AbstractIterator<Pair<Long, LongSet>>(){

            @Override
            protected Pair<Long, LongSet> computeNext() {
                if (!iterator.hasNext()) {
                    return (Pair)this.endOfData();
                }
                Token token = (Token)iterator.next();
                return Pair.create(token.get(), token.getOffsets());
            }
        };
    }

    @Override
    public long getTokenCount() {
        return this.tokenCount;
    }

    @Override
    public void write(DataOutputPlus out) throws IOException {
        super.write(out);
        if (this.root.isLeaf()) {
            return;
        }
        RangeIterator<Long, Token> tokens = this.combinedTerm.getTokenIterator();
        ByteBuffer blockBuffer = ByteBuffer.allocate(4096);
        Iterator<AbstractTokenTreeBuilder.Node> leafIterator = this.leftmostLeaf.levelIterator();
        while (leafIterator.hasNext()) {
            AbstractTokenTreeBuilder.Leaf leaf = (AbstractTokenTreeBuilder.Leaf)leafIterator.next();
            StaticLeaf writeableLeaf = new StaticLeaf(Iterators.limit(tokens, leaf.tokenCount()), leaf);
            writeableLeaf.serialize(-1L, blockBuffer);
            this.flushBuffer(blockBuffer, out, true);
        }
    }

    @Override
    protected void constructTree() {
        RangeIterator<Long, Token> tokens = this.combinedTerm.getTokenIterator();
        this.tokenCount = 0L;
        this.treeMinToken = tokens.getMinimum();
        this.treeMaxToken = tokens.getMaximum();
        this.numBlocks = 1;
        this.root = new AbstractTokenTreeBuilder.InteriorNode();
        this.rightmostParent = (AbstractTokenTreeBuilder.InteriorNode)this.root;
        PartialLeaf lastLeaf = null;
        Long firstToken = null;
        int leafSize = 0;
        while (tokens.hasNext()) {
            Long token = ((Token)tokens.next()).get();
            if (firstToken == null) {
                firstToken = token;
            }
            ++this.tokenCount;
            ++leafSize;
            if (this.tokenCount % 248L != 0L && token != this.treeMaxToken) continue;
            Long lastToken = token;
            PartialLeaf leaf = new PartialLeaf(firstToken, lastToken, leafSize);
            if (lastLeaf == null) {
                this.leftmostLeaf = leaf;
            } else {
                lastLeaf.next = leaf;
            }
            this.rightmostParent.add(leaf);
            this.rightmostLeaf = leaf;
            lastLeaf = this.rightmostLeaf;
            firstToken = null;
            ++this.numBlocks;
            leafSize = 0;
        }
        if (this.root.tokenCount() == 0) {
            this.numBlocks = 1;
            this.root = new StaticLeaf(this.combinedTerm.getTokenIterator(), this.treeMinToken, this.treeMaxToken, this.tokenCount, true);
        }
    }

    private class StaticLeaf
    extends AbstractTokenTreeBuilder.Leaf {
        private final Iterator<Token> tokens;
        private final int count;
        private final boolean isLast;

        public StaticLeaf(Iterator<Token> tokens, AbstractTokenTreeBuilder.Leaf leaf) {
            this(tokens, leaf.smallestToken(), leaf.largestToken(), leaf.tokenCount(), leaf.isLastLeaf());
        }

        public StaticLeaf(Iterator<Token> tokens, Long min2, Long max, long count, boolean isLastLeaf) {
            super(min2, max);
            this.count = (int)count;
            this.tokens = tokens;
            this.isLast = isLastLeaf;
        }

        @Override
        public boolean isLastLeaf() {
            return this.isLast;
        }

        @Override
        public int tokenCount() {
            return this.count;
        }

        @Override
        public void serializeData(ByteBuffer buf) {
            while (this.tokens.hasNext()) {
                Token entry = this.tokens.next();
                this.createEntry(entry.get(), entry.getOffsets()).serialize(buf);
            }
        }

        @Override
        public boolean isSerializable() {
            return true;
        }
    }

    private class PartialLeaf
    extends AbstractTokenTreeBuilder.Leaf {
        private final int size;

        public PartialLeaf(Long min2, Long max, int count) {
            super(min2, max);
            this.size = count;
        }

        @Override
        public int tokenCount() {
            return this.size;
        }

        @Override
        public void serializeData(ByteBuffer buf) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSerializable() {
            return false;
        }
    }
}

