/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.cliffc.high_scale_lib.NonBlockingHashtable;

public class Hashtable<K, V>
extends NonBlockingHashtable<K, V> {
    private static final long serialVersionUID = 1421746759512286392L;
    private final float loadFactor = 0.75f;
    private int threshold = 3;

    public Hashtable() {
    }

    public Hashtable(int initialCapacity) {
        super(initialCapacity);
    }

    public Hashtable(int initialCapacity, float loadFactor) {
        super(initialCapacity);
        if (!(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public Hashtable(Map<? extends K, ? extends V> t) {
        this.putAll(t);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        Hashtable t = (Hashtable)this.clone();
        s2.defaultWriteObject();
        s2.writeInt((int)((float)t.size() / 0.75f));
        s2.writeInt(t.size());
        for (Object K2 : this.keySet()) {
            Object V = this.get(K2);
            s2.writeObject(K2);
            s2.writeObject(V);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.initialize();
        int origlength = s2.readInt();
        int elements = s2.readInt();
        for (int i = 0; i < elements; ++i) {
            Object key = s2.readObject();
            Object value = s2.readObject();
            this.put(key, value);
        }
    }
}

