/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.sidecar;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.cdc.api.CommitLog;
import org.apache.cassandra.cdc.api.CommitLogProvider;
import org.apache.cassandra.cdc.sidecar.ClusterConfigProvider;
import org.apache.cassandra.cdc.sidecar.ReplicationFactorSupplier;
import org.apache.cassandra.cdc.sidecar.SidecarCdcClient;
import org.apache.cassandra.cdc.sidecar.SidecarDownMonitor;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.data.partitioner.CassandraRing;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.utils.FutureUtils;
import org.apache.cassandra.spark.utils.ThrowableUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarCommitLogProvider
implements CommitLogProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarCommitLogProvider.class);
    private final ClusterConfigProvider clusterConfigProvider;
    private final SidecarCdcClient sidecarCdcClient;
    private final SidecarDownMonitor downMonitor;
    private final Predicate<CassandraInstance> dcFilter;
    private final ReplicationFactorSupplier replicationFactorSupplier;

    public SidecarCommitLogProvider(ClusterConfigProvider clusterConfigProvider, SidecarCdcClient sidecarCdcClient, SidecarDownMonitor downMonitor, ReplicationFactorSupplier replicationFactorSupplier) {
        this.clusterConfigProvider = clusterConfigProvider;
        this.sidecarCdcClient = sidecarCdcClient;
        this.downMonitor = downMonitor;
        this.replicationFactorSupplier = replicationFactorSupplier;
        this.dcFilter = inst -> {
            String dc = clusterConfigProvider.dc();
            return dc == null || inst.dataCenter().equalsIgnoreCase(dc);
        };
    }

    protected CassandraRing ring() {
        Set cluster = this.clusterConfigProvider.getCluster().stream().filter(this.dcFilter).collect(Collectors.toSet());
        Partitioner partitioner = this.clusterConfigProvider.partitioner();
        ReplicationFactor rf = this.replicationFactorSupplier.getMaximalReplicationFactor();
        return new CassandraRing(partitioner, "keyspace", rf, cluster);
    }

    protected static Range<BigInteger> toGuavaRange(TokenRange range) {
        return Range.openClosed((Comparable)range.lowerEndpoint(), (Comparable)range.upperEndpoint());
    }

    public Stream<CommitLog> logs(@Nullable TokenRange tokenRange) {
        List<Object> instances = tokenRange != null ? this.ring().getSubRanges(SidecarCommitLogProvider.toGuavaRange(tokenRange)).asMapOfRanges().values().stream().flatMap(Collection::stream).collect(Collectors.toList()) : new ArrayList(this.ring().instances());
        Set replicas = instances.stream().filter(this.dcFilter).filter(this.downMonitor::isUp).collect(Collectors.toSet());
        List futures = replicas.stream().map(this::listInstance).collect(Collectors.toList());
        List replicaLogs = FutureUtils.awaitAll(futures, (boolean)true, throwable -> LOGGER.warn("Failed to list CDC commit logs on instance", ThrowableUtils.rootCause((Throwable)throwable)));
        return replicaLogs.stream().flatMap(Collection::stream);
    }

    protected CompletableFuture<List<CommitLog>> listInstance(CassandraInstance instance) {
        return this.sidecarCdcClient.listCdcCommitLogSegments(instance).whenComplete((response, throwable) -> {
            if (response == null || throwable != null) {
                LOGGER.warn("Failed to list commit log segments on instance nodeName={}", (Object)instance.nodeName(), throwable);
                this.downMonitor.hintDown(instance);
            }
        });
    }
}

