/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.sidecar;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.stream.Collectors;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.client.SidecarInstanceImpl;
import o.a.c.sidecar.client.shaded.client.SidecarInstancesProvider;
import o.a.c.sidecar.client.shaded.client.SimpleSidecarInstancesProvider;
import org.apache.cassandra.cdc.CdcBuilder;
import org.apache.cassandra.cdc.api.CdcOptions;
import org.apache.cassandra.cdc.api.EventConsumer;
import org.apache.cassandra.cdc.api.SchemaSupplier;
import org.apache.cassandra.cdc.api.TokenRangeSupplier;
import org.apache.cassandra.cdc.sidecar.CdcSidecarInstancesProvider;
import org.apache.cassandra.cdc.sidecar.ClusterConfigProvider;
import org.apache.cassandra.cdc.sidecar.ReplicationFactorSupplier;
import org.apache.cassandra.cdc.sidecar.SidecarCdc;
import org.apache.cassandra.cdc.sidecar.SidecarCdcCassandraClient;
import org.apache.cassandra.cdc.sidecar.SidecarCdcClient;
import org.apache.cassandra.cdc.sidecar.SidecarCdcOptions;
import org.apache.cassandra.cdc.sidecar.SidecarCdcStats;
import org.apache.cassandra.cdc.sidecar.SidecarCommitLogProvider;
import org.apache.cassandra.cdc.sidecar.SidecarDownMonitor;
import org.apache.cassandra.cdc.sidecar.SidecarStatePersister;
import org.apache.cassandra.cdc.stats.ICdcStats;
import org.apache.cassandra.clients.Sidecar;
import org.apache.cassandra.secrets.SecretsProvider;
import org.apache.cassandra.spark.utils.AsyncExecutor;
import org.jetbrains.annotations.NotNull;

public class SidecarCdcBuilder
extends CdcBuilder {
    protected ClusterConfigProvider clusterConfigProvider;
    protected SidecarCdcClient sidecarCdcClient;
    protected SidecarDownMonitor downMonitor = SidecarDownMonitor.STUB;
    protected ReplicationFactorSupplier replicationFactorSupplier = ReplicationFactorSupplier.DEFAULT;
    protected SidecarCdcStats sidecarCdcStats = SidecarCdcStats.STUB;
    protected SidecarCdcCassandraClient cassandraClient = SidecarCdcCassandraClient.STUB;
    protected SidecarCdcOptions sidecarCdcOptions = SidecarCdcOptions.DEFAULT;

    SidecarCdcBuilder(@NotNull String jobId, int partitionId, CdcOptions cdcOptions, ClusterConfigProvider clusterConfigProvider, EventConsumer eventConsumer, SchemaSupplier schemaSupplier, TokenRangeSupplier tokenRangeSupplier, CdcSidecarInstancesProvider sidecarInstancesProvider, SidecarCdcClient.ClientConfig clientConfig, SecretsProvider secretsProvider, ICdcStats cdcStats) throws IOException {
        this(jobId, partitionId, cdcOptions, clusterConfigProvider, eventConsumer, schemaSupplier, tokenRangeSupplier, clientConfig, Sidecar.from((SidecarInstancesProvider)new SimpleSidecarInstancesProvider(sidecarInstancesProvider.instances().stream().map(i -> new SidecarInstanceImpl(i.hostname(), i.port())).collect(Collectors.toList())), (Sidecar.ClientConfig)clientConfig.toGenericSidecarConfig(), (SecretsProvider)secretsProvider), cdcStats);
    }

    SidecarCdcBuilder(@NotNull String jobId, int partitionId, CdcOptions cdcOptions, ClusterConfigProvider clusterConfigProvider, EventConsumer eventConsumer, SchemaSupplier schemaSupplier, TokenRangeSupplier tokenRangeSupplier, SidecarCdcClient.ClientConfig clientConfig, SidecarClient sidecarClient, ICdcStats cdcStats) {
        super(jobId, partitionId, eventConsumer, schemaSupplier);
        this.clusterConfigProvider = clusterConfigProvider;
        this.sidecarCdcClient = new SidecarCdcClient(clientConfig, sidecarClient, cdcStats);
        this.withCdcOptions(cdcOptions);
        this.withTokenRangeSupplier(tokenRangeSupplier);
    }

    public SidecarCdcBuilder withClusterConfigProvider(ClusterConfigProvider clusterConfigProvider) {
        this.clusterConfigProvider = clusterConfigProvider;
        return this;
    }

    public SidecarCdcBuilder withDownMonitor(SidecarDownMonitor downMonitor) {
        this.downMonitor = downMonitor;
        return this;
    }

    public SidecarCdcBuilder withSidecarClient(SidecarCdcClient.ClientConfig clientConfig, SidecarClient sidecarClient, ICdcStats cdcStats) {
        this.sidecarCdcClient = new SidecarCdcClient(clientConfig, sidecarClient, cdcStats);
        return this;
    }

    public SidecarCdcBuilder withReplicationFactorSupplier(ReplicationFactorSupplier replicationFactorSupplier) {
        this.replicationFactorSupplier = replicationFactorSupplier;
        return this;
    }

    public CdcBuilder withCdcOptions(@NotNull CdcOptions cdcOptions) {
        super.withCdcOptions(cdcOptions);
        return this.withSidecarCdcCassandraClient(this.cassandraClient);
    }

    public SidecarCdcBuilder withSidecarCdcStats(SidecarCdcStats sidecarCdcStats) {
        this.sidecarCdcStats = sidecarCdcStats;
        return this.withSidecarCdcCassandraClient(this.cassandraClient);
    }

    public SidecarCdcBuilder withSidecarCdcOptions(SidecarCdcOptions sidecarCdcOptions) {
        this.sidecarCdcOptions = sidecarCdcOptions;
        return this.withSidecarCdcCassandraClient(this.cassandraClient);
    }

    public SidecarCdcBuilder withExecutor(AsyncExecutor asyncExecutor) {
        super.withExecutor(asyncExecutor);
        return this.withSidecarCdcCassandraClient(this.cassandraClient);
    }

    public SidecarCdcBuilder withSidecarCdcCassandraClient(SidecarCdcCassandraClient cassandraClient) {
        this.cassandraClient = cassandraClient;
        return this.withSidecarStatePersister(new SidecarStatePersister(this.sidecarCdcOptions, this.cdcOptions, this.sidecarCdcStats, cassandraClient, this.asyncExecutor));
    }

    public SidecarCdcBuilder withSidecarStatePersister(SidecarStatePersister statePersister) {
        this.withStatePersister(statePersister);
        return this;
    }

    public SidecarCdc build() {
        Preconditions.checkNotNull((Object)this.clusterConfigProvider, (Object)"A ClusterConfigProvider must be supplied");
        Preconditions.checkNotNull((Object)this.asyncExecutor, (Object)"An AsyncExecutor must be supplied");
        Preconditions.checkNotNull((Object)this.eventConsumer, (Object)"An event consumer supplier must be supplied");
        Preconditions.checkNotNull((Object)this.schemaSupplier, (Object)"An schema supplier must be supplied");
        if (this.commitLogProvider == null) {
            this.commitLogProvider = new SidecarCommitLogProvider(this.clusterConfigProvider, this.sidecarCdcClient, this.downMonitor, this.replicationFactorSupplier);
        }
        return new SidecarCdc(this);
    }
}

