/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Supplier;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.cassandra.db.commitlog.CommitLogDescriptor;
import org.apache.cassandra.db.commitlog.CommitLogReadHandler;
import org.apache.cassandra.db.commitlog.CommitLogSegmentReader;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.spark.utils.LoggerHelper;
import org.apache.cassandra.utils.FBUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeekableCommitLogSegmentReader
implements Iterable<CommitLogSegmentReader.SyncSegment> {
    private final CommitLogReadHandler handler;
    private final RandomAccessReader reader;
    private final CommitLogSegmentReader.Segmenter segmenter;
    private final LoggerHelper logger;
    private final boolean tolerateTruncation;
    private final long segmentId;
    protected int end;

    protected SeekableCommitLogSegmentReader(long segmentId, CommitLogReadHandler handler, @Nullable CommitLogDescriptor desc, RandomAccessReader reader, LoggerHelper logger, boolean tolerateTruncation) {
        this.segmentId = segmentId;
        this.handler = handler;
        this.reader = reader;
        this.logger = logger;
        this.tolerateTruncation = tolerateTruncation;
        this.end = (int)reader.getFilePointer();
        if (desc != null && desc.getEncryptionContext().isEnabled()) {
            throw new UnsupportedOperationException("Encrypted CommitLogs currently not supported");
        }
        if (desc != null && desc.compression != null) {
            logger.trace("Opening CompressedSegmenter reader", new Supplier[0]);
            this.segmenter = new CommitLogSegmentReader.CompressedSegmenter(desc, reader);
        } else {
            logger.trace("Opening NoOpSegmenter reader", new Supplier[0]);
            this.segmenter = new CommitLogSegmentReader.NoOpSegmenter(reader);
        }
    }

    public void seek(int newPosition) {
        this.logger.trace("Seeking to position", new Object[]{"position", newPosition});
        this.end = newPosition;
    }

    private int readSyncMarker(int offset, RandomAccessReader reader) throws IOException {
        if ((long)offset > reader.length() - 8L) {
            return -1;
        }
        long current = reader.getFilePointer();
        if ((long)offset != current) {
            long timeNanos = System.nanoTime();
            reader.seek((long)offset);
            this.logger.debug("Seek to position", new Object[]{"from", current, "to", offset, "timeNanos", System.nanoTime() - timeNanos});
        }
        CRC32 crc = new CRC32();
        FBUtilities.updateChecksumInt((Checksum)crc, (int)((int)(this.segmentId & 0xFFFFFFFFL)));
        FBUtilities.updateChecksumInt((Checksum)crc, (int)((int)(this.segmentId >>> 32)));
        FBUtilities.updateChecksumInt((Checksum)crc, (int)((int)reader.getPosition()));
        int end = reader.readInt();
        long filecrc = (long)reader.readInt() & 0xFFFFFFFFL;
        if (crc.getValue() != filecrc) {
            if (end != 0 || filecrc != 0L) {
                String msg = String.format("Encountered bad header at position %d of commit log %s, with invalid CRC. The end of segment marker should be zero.", offset, reader.getPath());
                throw new CommitLogSegmentReader.SegmentReadException(msg, true);
            }
            return -1;
        }
        if (end < offset || (long)end > reader.length()) {
            String msg = String.format("Encountered bad header at position %d of commit log %s, with bad position but valid CRC", offset, reader.getPath());
            throw new CommitLogSegmentReader.SegmentReadException(msg, false);
        }
        return end;
    }

    @Override
    @NotNull
    public Iterator<CommitLogSegmentReader.SyncSegment> iterator() {
        return new SegmentIterator();
    }

    protected class SegmentIterator
    extends AbstractIterator<CommitLogSegmentReader.SyncSegment> {
        protected SegmentIterator() {
        }

        protected CommitLogSegmentReader.SyncSegment computeNext() {
            while (true) {
                try {
                    int currentStart = SeekableCommitLogSegmentReader.this.end;
                    SeekableCommitLogSegmentReader.this.end = SeekableCommitLogSegmentReader.this.readSyncMarker(currentStart, SeekableCommitLogSegmentReader.this.reader);
                    if (SeekableCommitLogSegmentReader.this.end == -1) {
                        return (CommitLogSegmentReader.SyncSegment)this.endOfData();
                    }
                    if ((long)SeekableCommitLogSegmentReader.this.end > SeekableCommitLogSegmentReader.this.reader.length()) {
                        SeekableCommitLogSegmentReader.this.end = (int)SeekableCommitLogSegmentReader.this.reader.length();
                    }
                    return SeekableCommitLogSegmentReader.this.segmenter.nextSegment(currentStart + 8, SeekableCommitLogSegmentReader.this.end);
                }
                catch (CommitLogSegmentReader.SegmentReadException e) {
                    try {
                        SeekableCommitLogSegmentReader.this.handler.handleUnrecoverableError(new CommitLogReadHandler.CommitLogReadException(e.getMessage(), CommitLogReadHandler.CommitLogReadErrorReason.UNRECOVERABLE_DESCRIPTOR_ERROR, !e.invalidCrc && SeekableCommitLogSegmentReader.this.tolerateTruncation));
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                catch (IOException e) {
                    try {
                        boolean tolerateErrorsInSection = SeekableCommitLogSegmentReader.this.tolerateTruncation & SeekableCommitLogSegmentReader.this.segmenter.tolerateSegmentErrors(SeekableCommitLogSegmentReader.this.end, SeekableCommitLogSegmentReader.this.reader.length());
                        SeekableCommitLogSegmentReader.this.handler.handleUnrecoverableError(new CommitLogReadHandler.CommitLogReadException(e.getMessage(), CommitLogReadHandler.CommitLogReadErrorReason.UNRECOVERABLE_DESCRIPTOR_ERROR, tolerateErrorsInSection));
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            }
        }
    }
}

