/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.net.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import o.a.c.sidecar.client.shaded.io.netty.channel.Channel;
import o.a.c.sidecar.client.shaded.io.netty.channel.ChannelFuture;
import o.a.c.sidecar.client.shaded.io.netty.channel.ChannelPromise;
import o.a.c.sidecar.client.shaded.io.netty.channel.EventLoop;
import o.a.c.sidecar.client.shaded.io.netty.channel.EventLoopGroup;
import o.a.c.sidecar.client.shaded.io.netty.util.concurrent.AbstractEventExecutorGroup;
import o.a.c.sidecar.client.shaded.io.netty.util.concurrent.EventExecutor;
import o.a.c.sidecar.client.shaded.io.netty.util.concurrent.Future;

public final class VertxEventLoopGroup
extends AbstractEventExecutorGroup
implements EventLoopGroup {
    private int pos;
    private final List<EventLoopHolder> workers = new ArrayList<EventLoopHolder>();
    private final Set<EventExecutor> children = new Set<EventExecutor>(){

        @Override
        public Iterator<EventExecutor> iterator() {
            return new EventLoopIterator(VertxEventLoopGroup.this.workers.iterator());
        }

        @Override
        public int size() {
            return VertxEventLoopGroup.this.workers.size();
        }

        @Override
        public boolean isEmpty() {
            return VertxEventLoopGroup.this.workers.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return VertxEventLoopGroup.this.workers.contains(o);
        }

        @Override
        public Object[] toArray() {
            return VertxEventLoopGroup.this.workers.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return VertxEventLoopGroup.this.workers.toArray(a);
        }

        @Override
        public boolean add(EventExecutor eventExecutor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return VertxEventLoopGroup.this.workers.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends EventExecutor> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    };

    @Override
    public synchronized EventLoop next() {
        if (this.workers.isEmpty()) {
            throw new IllegalStateException();
        }
        EventLoop worker = this.workers.get((int)this.pos).worker;
        ++this.pos;
        this.checkPos();
        return worker;
    }

    @Override
    public Iterator<EventExecutor> iterator() {
        return this.children.iterator();
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.next().register(channel);
    }

    @Override
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return this.next().register(channel, promise);
    }

    @Override
    public ChannelFuture register(ChannelPromise promise) {
        return this.next().register(promise);
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown();
    }

    @Override
    public synchronized boolean awaitTermination(long timeout, TimeUnit unit) {
        return false;
    }

    public synchronized void addWorker(EventLoop worker) {
        EventLoopHolder holder = this.findHolder(worker);
        if (holder == null) {
            this.workers.add(new EventLoopHolder(worker));
        } else {
            ++holder.count;
        }
    }

    @Override
    public synchronized void shutdown() {
        throw new UnsupportedOperationException("Should never be called");
    }

    @Override
    public boolean isShuttingDown() {
        return false;
    }

    @Override
    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException("Should never be called");
    }

    @Override
    public Future<?> terminationFuture() {
        throw new UnsupportedOperationException("Should never be called");
    }

    private EventLoopHolder findHolder(EventLoop worker) {
        EventLoopHolder wh = new EventLoopHolder(worker);
        for (EventLoopHolder holder : this.workers) {
            if (!holder.equals(wh)) continue;
            return holder;
        }
        return null;
    }

    public synchronized void removeWorker(EventLoop worker) {
        EventLoopHolder holder = this.findHolder(worker);
        if (holder != null) {
            --holder.count;
            if (holder.count == 0) {
                this.workers.remove(holder);
            }
        } else {
            throw new IllegalStateException("Can't find worker to remove");
        }
        this.checkPos();
    }

    public synchronized int workerCount() {
        return this.workers.size();
    }

    private void checkPos() {
        if (this.pos == this.workers.size()) {
            this.pos = 0;
        }
    }

    private static final class EventLoopIterator
    implements Iterator<EventExecutor> {
        private final Iterator<EventLoopHolder> holderIt;

        public EventLoopIterator(Iterator<EventLoopHolder> holderIt) {
            this.holderIt = holderIt;
        }

        @Override
        public boolean hasNext() {
            return this.holderIt.hasNext();
        }

        @Override
        public EventExecutor next() {
            return this.holderIt.next().worker;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("read-only");
        }
    }

    private static class EventLoopHolder {
        int count = 1;
        final EventLoop worker;

        EventLoopHolder(EventLoop worker) {
            this.worker = worker;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventLoopHolder that = (EventLoopHolder)o;
            return Objects.equals(this.worker, that.worker);
        }

        public int hashCode() {
            return Objects.hashCode(this.worker);
        }
    }
}

