/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.spark.data.AbstractCqlType;

public abstract class CqlType
extends AbstractCqlType {
    @Override
    public CassandraVersion version() {
        return CassandraVersion.FIVEZERO;
    }

    @Override
    @VisibleForTesting
    public void addComplexTombstone(Row.Builder rowBuilder, ColumnMetadata cd, long deletionTime) {
        Preconditions.checkArgument((boolean)cd.isComplex(), (Object)"The method only works with complex columns");
        rowBuilder.addComplexDeletion(cd, DeletionTime.build((long)deletionTime, (long)((int)TimeUnit.MICROSECONDS.toSeconds(deletionTime))));
    }
}

