/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import com.datastax.driver.core.utils.UUIDs;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.analytics.SparkTestUtils;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.api.ICoordinator;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class PartitionKeyIntegrationTest
extends SharedClusterSparkIntegrationTestBase {
    static final List<String> DATASET = Arrays.asList("a", "b", "c", "d", "e", "f", "g");
    static final List<String> REDUCED_DATASET_FOR_BOOLEAN = Arrays.asList("a", "b");
    static final String CREATE_TEST_TABLE_SINGLE_PK_STATEMENT = "CREATE TABLE IF NOT EXISTS %s (id %s, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';";
    static final String CREATE_TEST_TABLE_COMPOSITE_PK_STATEMENT = "CREATE TABLE IF NOT EXISTS %s (id %s, course %s, marks int, PRIMARY KEY ((id,course))) WITH read_repair='NONE';";
    static final long CURRENT_TIMESTAMP = System.currentTimeMillis();

    PartitionKeyIntegrationTest() {
    }

    @ParameterizedTest(name="CQL Type for Partition Key={0}")
    @MethodSource(value={"mappings"})
    void allTypesInSinglePartitionKey(String typeName, Function<Integer, String> ignored, Function<Object[], String> columnsMapper, Function<Row, String> rowMapper) {
        QualifiedName sourceTableName = new QualifiedName("spark_test", typeName + "_source");
        QualifiedName targetTableName = new QualifiedName("spark_test", typeName + "_target");
        Dataset data = this.bulkReaderDataFrame(sourceTableName).load();
        if (typeName.equals("boolean")) {
            Assertions.assertThat((long)data.count()).isEqualTo((long)REDUCED_DATASET_FOR_BOOLEAN.size());
        } else {
            Assertions.assertThat((long)data.count()).isEqualTo((long)DATASET.size());
        }
        List<Row> rowList = data.collectAsList().stream().sorted(Comparator.comparing(row -> row.getInt(2))).collect(Collectors.toList());
        this.bulkWriterDataFrameWriter((Dataset<Row>)data, targetTableName).save();
        this.sparkTestUtils.validateWrites(rowList, this.queryAllData(targetTableName), columnsMapper, rowMapper);
    }

    @ParameterizedTest(name="CQL Type for Composite Partition Key={0}-{0}")
    @MethodSource(value={"mappings"})
    void allTypesInCompositePartitionKey(String typeName, Function<Integer, String> ignored, Function<Object[], String> columnsMapper, Function<Row, String> rowMapper) {
        QualifiedName compositeSourceTableName = new QualifiedName("spark_test", typeName + "_composite_source");
        QualifiedName compositeTargetTableName = new QualifiedName("spark_test", typeName + "_composite_target");
        Dataset data = this.bulkReaderDataFrame(compositeSourceTableName).load();
        if (typeName.equals("boolean")) {
            Assertions.assertThat((long)data.count()).isEqualTo((long)REDUCED_DATASET_FOR_BOOLEAN.size());
        } else {
            Assertions.assertThat((long)data.count()).isEqualTo((long)DATASET.size());
        }
        List<Row> rowList = data.collectAsList().stream().sorted(Comparator.comparing(row -> row.getInt(2))).collect(Collectors.toList());
        this.bulkWriterDataFrameWriter((Dataset<Row>)data, compositeTargetTableName).save();
        this.sparkTestUtils.validateWrites(rowList, this.queryAllData(compositeTargetTableName), columnsMapper, rowMapper);
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF1);
        this.mappings().forEach(arguments -> {
            Object[] args = arguments.get();
            Object typeName = args[0];
            QualifiedName sourceTableName = new QualifiedName("spark_test", String.valueOf(typeName) + "_source");
            QualifiedName targetTableName = new QualifiedName("spark_test", String.valueOf(typeName) + "_target");
            this.createTestTable(sourceTableName, String.format(CREATE_TEST_TABLE_SINGLE_PK_STATEMENT, "%s", typeName));
            this.createTestTable(targetTableName, String.format(CREATE_TEST_TABLE_SINGLE_PK_STATEMENT, "%s", typeName));
            QualifiedName compositeSourceTableName = new QualifiedName("spark_test", String.valueOf(typeName) + "_composite_source");
            QualifiedName compositeTargetTableName = new QualifiedName("spark_test", String.valueOf(typeName) + "_composite_target");
            this.createTestTable(compositeSourceTableName, String.format(CREATE_TEST_TABLE_COMPOSITE_PK_STATEMENT, "%s", typeName, typeName));
            this.createTestTable(compositeTargetTableName, String.format(CREATE_TEST_TABLE_COMPOSITE_PK_STATEMENT, "%s", typeName, typeName));
            Function typeToRowValueFn = (Function)args[1];
            if (typeName.equals("boolean")) {
                this.populateTable(sourceTableName, REDUCED_DATASET_FOR_BOOLEAN, typeToRowValueFn);
                this.populateCompositePKTable(compositeSourceTableName, REDUCED_DATASET_FOR_BOOLEAN, typeToRowValueFn);
            } else {
                this.populateTable(sourceTableName, DATASET, typeToRowValueFn);
                this.populateCompositePKTable(compositeSourceTableName, DATASET, typeToRowValueFn);
            }
        });
    }

    void populateTable(QualifiedName tableName, List<String> values, Function<Integer, String> typeToRowValueFn) {
        ICoordinator coordinator = this.cluster.getFirstRunningInstance().coordinator();
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            String query = String.format("INSERT INTO %s (id, course, marks) VALUES (%s,'%s',%d) ", tableName, typeToRowValueFn.apply(i), "course_" + value, 80 + i);
            coordinator.execute(query, ConsistencyLevel.ALL, new Object[0]);
        }
    }

    void populateCompositePKTable(QualifiedName tableName, List<String> values, Function<Integer, String> typeToRowValueFn) {
        ICoordinator coordinator = this.cluster.getFirstRunningInstance().coordinator();
        for (int i = 0; i < values.size(); ++i) {
            String value = typeToRowValueFn.apply(i);
            String query = String.format("INSERT INTO %s (id, course, marks) VALUES (%s,%s,%d) ", tableName, value, value, 80 + i);
            coordinator.execute(query, ConsistencyLevel.ALL, new Object[0]);
        }
    }

    Stream<Arguments> mappings() {
        return Stream.of(Arguments.of((Object[])new Object[]{"bigint", String::valueOf, SparkTestUtils.VALIDATION_DEFAULT_COLUMNS_MAPPER, SparkTestUtils.VALIDATION_DEFAULT_ROW_MAPPER}), Arguments.of((Object[])new Object[]{"blob", value -> String.format("bigintAsBlob(%d)", value), columns -> {
            String col0 = new BigInteger(ByteBufferUtils.getArray((ByteBuffer)((ByteBuffer)columns[0]))).toString();
            if (columns[1] instanceof ByteBuffer) {
                String col1 = new BigInteger(ByteBufferUtils.getArray((ByteBuffer)((ByteBuffer)columns[1]))).toString();
                return String.format("%s:%s:%s", col0, col1, columns[2]);
            }
            return String.format("%s:%s:%s", col0, columns[1], columns[2]);
        }, row -> {
            byte[] col0 = (byte[])row.get(0);
            Object col1 = row.get(1);
            if (col1 instanceof byte[]) {
                return String.format("%s:%s:%d", new BigInteger(col0), new BigInteger((byte[])col1), row.getInt(2));
            }
            return String.format("%s:%s:%d", new BigInteger(col0), col1, row.getInt(2));
        }}), Arguments.of((Object[])new Object[]{"double", String::valueOf, SparkTestUtils.VALIDATION_DEFAULT_COLUMNS_MAPPER, SparkTestUtils.VALIDATION_DEFAULT_ROW_MAPPER}), Arguments.of((Object[])new Object[]{"int", String::valueOf, SparkTestUtils.VALIDATION_DEFAULT_COLUMNS_MAPPER, SparkTestUtils.VALIDATION_DEFAULT_ROW_MAPPER}), Arguments.of((Object[])new Object[]{"boolean", value -> value % 2 == 0 ? "true" : "false", SparkTestUtils.VALIDATION_DEFAULT_COLUMNS_MAPPER, SparkTestUtils.VALIDATION_DEFAULT_ROW_MAPPER}), Arguments.of((Object[])new Object[]{"text", value -> String.format("'%d'", value), SparkTestUtils.VALIDATION_DEFAULT_COLUMNS_MAPPER, SparkTestUtils.VALIDATION_DEFAULT_ROW_MAPPER}), Arguments.of((Object[])new Object[]{"timestamp", offset -> String.valueOf(CURRENT_TIMESTAMP + (long)offset.intValue()), SparkTestUtils.VALIDATION_DEFAULT_COLUMNS_MAPPER, row -> {
            Date col0 = new Date(row.getTimestamp(0).getTime());
            Object col1 = row.get(1);
            if (col1 instanceof Timestamp) {
                return String.format("%s:%s:%d", col0, new Date(((Timestamp)col1).getTime()), row.getInt(2));
            }
            return String.format("%s:%s:%d", col0, row.get(1), row.getInt(2));
        }}), Arguments.of((Object[])new Object[]{"uuid", value -> new UUID(0L, value.intValue()).toString(), SparkTestUtils.VALIDATION_DEFAULT_COLUMNS_MAPPER, SparkTestUtils.VALIDATION_DEFAULT_ROW_MAPPER}), Arguments.of((Object[])new Object[]{"varchar", value -> String.format("'%d'", value), SparkTestUtils.VALIDATION_DEFAULT_COLUMNS_MAPPER, SparkTestUtils.VALIDATION_DEFAULT_ROW_MAPPER}), Arguments.of((Object[])new Object[]{"ascii", value -> String.format("'%d'", value), SparkTestUtils.VALIDATION_DEFAULT_COLUMNS_MAPPER, SparkTestUtils.VALIDATION_DEFAULT_ROW_MAPPER}), Arguments.of((Object[])new Object[]{"timeuuid", offset -> UUIDs.startOf((long)(CURRENT_TIMESTAMP + (long)offset.intValue())).toString(), SparkTestUtils.VALIDATION_DEFAULT_COLUMNS_MAPPER, SparkTestUtils.VALIDATION_DEFAULT_ROW_MAPPER}));
    }
}

