/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.cassandra.analytics.DataGenerationUtils;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.spark.bulkwriter.WriterOptions;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class CassandraAnalyticsSimpleTest
extends SharedClusterSparkIntegrationTestBase {
    private static final List<QualifiedName> QUALIFIED_NAMES = Arrays.asList(new QualifiedName("spark_test", "test_no_tll_timestamp"), new QualifiedName("spark_test", "test_ttl_1000"), new QualifiedName("spark_test", "test_timestamp"), new QualifiedName("spark_test", "test_ttl_1000_timestamp"));

    CassandraAnalyticsSimpleTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"options"})
    @Timeout(value=30L)
    void runSampleJob(Integer ttl, Long timestamp, QualifiedName tableName) {
        HashMap<String, String> writerOptions = new HashMap<String, String>();
        if (ttl != null) {
            writerOptions.put(WriterOptions.TTL.name(), "ttl");
        }
        if (timestamp != null) {
            writerOptions.put(WriterOptions.TIMESTAMP.name(), "timestamp");
        }
        SparkSession spark = this.getOrCreateSparkSession();
        Dataset<Row> dfWrite = DataGenerationUtils.generateCourseData(spark, 1000, false, ttl, timestamp);
        this.bulkWriterDataFrameWriter(dfWrite, tableName, writerOptions).save();
        this.sparkTestUtils.validateWrites(dfWrite.collectAsList(), this.queryAllData(tableName));
        Dataset<Row> written = CassandraAnalyticsSimpleTest.writeToReadDfFunc(ttl != null, timestamp != null).apply(dfWrite);
        Dataset read = this.bulkReaderDataFrame(tableName).load();
        this.checkSmallDataFrameEquality(written, (Dataset<Row>)read);
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF3);
        QUALIFIED_NAMES.forEach(tableName -> this.createTestTable((QualifiedName)tableName, "CREATE TABLE IF NOT EXISTS %s (id int, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';"));
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return super.testClusterConfiguration().nodesPerDc(3);
    }

    static Stream<Arguments> options() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, null, QUALIFIED_NAMES.get(0)}), Arguments.of((Object[])new Object[]{1000, null, QUALIFIED_NAMES.get(1)}), Arguments.of((Object[])new Object[]{null, 1432815430948567L, QUALIFIED_NAMES.get(2)}), Arguments.of((Object[])new Object[]{1000, 1432815430948567L, QUALIFIED_NAMES.get(3)}));
    }

    static Function<Dataset<Row>, Dataset<Row>> writeToReadDfFunc(boolean addedTTLColumn, boolean addedTimestampColumn) {
        return df -> {
            if (addedTTLColumn) {
                df = df.drop("ttl");
            }
            if (addedTimestampColumn) {
                df = df.drop("timestamp");
            }
            return df;
        };
    }
}

