/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.analytics.SparkTestUtils;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.api.ICluster;
import org.apache.cassandra.distributed.api.IInstance;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BulkReaderTest
extends SharedClusterSparkIntegrationTestBase {
    static final List<String> DATASET = Arrays.asList("a", "b", "c", "d", "e", "f", "g");
    QualifiedName table1 = TestUtils.uniqueTestTableFullName((String)"spark_test");
    QualifiedName table2 = TestUtils.uniqueTestTableFullName((String)"spark_test");
    QualifiedName tableForNullStaticColumn = TestUtils.uniqueTestTableFullName((String)"spark_test");

    BulkReaderTest() {
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return super.testClusterConfiguration().nodesPerDc(2);
    }

    @Test
    void testDynamicSizingOption() {
        Dataset data = this.bulkReaderDataFrame(this.table1).option("SIZING", "dynamic").load();
        List rows = data.collectAsList().stream().sorted(Comparator.comparing(row -> row.getInt(0))).collect(Collectors.toList());
        Assertions.assertThat((int)rows.size()).isEqualTo(DATASET.size());
    }

    @Test
    void failsOnInvalidSizingOption() {
        Assertions.assertThatRuntimeException().isThrownBy(() -> this.bulkReaderDataFrame(this.tableForNullStaticColumn).option("SIZING", "invalid").load()).withMessageContaining("Invalid sizing option provided 'invalid'");
    }

    @Test
    void testReadNullStaticColumn() {
        Dataset data = this.bulkReaderDataFrame(this.tableForNullStaticColumn).load();
        List rows = data.collectAsList().stream().sorted(Comparator.comparing(row -> row.getString(0))).collect(Collectors.toList());
        Assertions.assertThat((int)rows.size()).isEqualTo(DATASET.size());
        for (int i = 0; i < DATASET.size(); ++i) {
            Row row2 = (Row)rows.get(i);
            Assertions.assertThat((String)row2.getString(0)).isEqualTo(DATASET.get(i));
            Assertions.assertThat((long)row2.getTimestamp(1).getTime()).isEqualTo(1432815430948560L + (long)i);
            if (i % 2 == 0) {
                ((AbstractDateAssert)Assertions.assertThat((Date)row2.getTimestamp(2)).as("Row " + (i + 1) + " is expected to have null timestamp", new Object[0])).isNull();
                continue;
            }
            Assertions.assertThat((long)row2.getTimestamp(2).getTime()).isEqualTo(1432815430948560L + (long)i);
        }
    }

    @Test
    void testReadingFromTwoDifferentTables() {
        Dataset dataForTable1 = this.bulkReaderDataFrame(this.table1).load();
        Dataset dataForTable2 = this.bulkReaderDataFrame(this.table2).load();
        Assertions.assertThat((long)dataForTable1.count()).isEqualTo((long)DATASET.size());
        Assertions.assertThat((long)dataForTable2.count()).isEqualTo((long)DATASET.size());
        List rowList1 = dataForTable1.collectAsList().stream().sorted(Comparator.comparing(row -> row.getInt(0))).collect(Collectors.toList());
        List rowList2 = dataForTable2.collectAsList().stream().sorted(Comparator.comparing(row -> row.getLong(1))).collect(Collectors.toList());
        for (int i = 0; i < DATASET.size(); ++i) {
            Assertions.assertThat((int)((Row)rowList1.get(i)).getInt(0)).isEqualTo(i);
            Assertions.assertThat((String)((Row)rowList1.get(i)).getString(1)).isEqualTo(DATASET.get(i));
            Assertions.assertThat((String)((Row)rowList2.get(i)).getString(0)).isEqualTo(DATASET.get(i));
            Assertions.assertThat((long)((Row)rowList2.get(i)).getLong(1)).isEqualTo((long)i);
        }
    }

    @Test
    void testUsingSingleSidecarContactPoint() {
        String singleSidecar = SparkTestUtils.sidecarInstancesOptionStream((ICluster<? extends IInstance>)this.cluster, this.dnsResolver).limit(1L).collect(Collectors.joining());
        Assertions.assertThat((int)this.cluster.size()).isEqualTo(2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)singleSidecar.contains(",")).describedAs("should not contain the separator ',' as it should have one single contact point", new Object[0])).isFalse();
        Dataset data = this.bulkReaderDataFrame(this.table1, Collections.singletonMap("sidecar_contact_points", singleSidecar)).load();
        List rows = data.collectAsList().stream().sorted(Comparator.comparing(row -> row.getInt(0))).collect(Collectors.toList());
        Assertions.assertThat((int)rows.size()).isEqualTo(DATASET.size());
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF1);
        this.createTestTable(this.table1, "CREATE TABLE IF NOT EXISTS %s (id int PRIMARY KEY, name text);");
        this.createTestTable(this.table2, "CREATE TABLE IF NOT EXISTS %s (name text PRIMARY KEY, value bigint);");
        this.createTestTable(this.tableForNullStaticColumn, "CREATE TABLE %s (id text, timestamp timestamp,\n   timestamp_static timestamp static, PRIMARY KEY (id, timestamp));");
        IInstance firstRunningInstance = this.cluster.getFirstRunningInstance();
        for (int i = 0; i < DATASET.size(); ++i) {
            String value = DATASET.get(i);
            String query1 = String.format("INSERT INTO %s (id, name) VALUES (%d, '%s');", this.table1, i, value);
            String query2 = String.format("INSERT INTO %s (name, value) VALUES ('%s', %d);", this.table2, value, i);
            String query3 = String.format("INSERT INTO %s (id, timestamp, timestamp_static) VALUES ('%s',%d, %s)", this.tableForNullStaticColumn, value, 1432815430948560L + (long)i, i % 2 == 0 ? "null" : String.valueOf((long)i + 1432815430948560L));
            firstRunningInstance.coordinator().execute(query1, ConsistencyLevel.ALL, new Object[0]);
            firstRunningInstance.coordinator().execute(query2, ConsistencyLevel.ALL, new Object[0]);
            firstRunningInstance.coordinator().execute(query3, ConsistencyLevel.ALL, new Object[0]);
        }
    }
}

