/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.spark.data.DataLayer;
import org.apache.cassandra.spark.sparksql.CassandraScanBuilder;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

class CassandraTable
implements Table,
SupportsRead {
    private final DataLayer dataLayer;
    private final StructType schema;

    CassandraTable(DataLayer dataLayer, StructType schema) {
        this.dataLayer = dataLayer;
        this.schema = schema;
    }

    public String name() {
        return this.dataLayer.cqlTable().keyspace() + "." + this.dataLayer.cqlTable().table();
    }

    public StructType schema() {
        return this.schema;
    }

    public Set<TableCapability> capabilities() {
        return new HashSet<TableCapability>((Collection<TableCapability>)ImmutableList.of((Object)TableCapability.BATCH_READ, (Object)TableCapability.MICRO_BATCH_READ));
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        return new CassandraScanBuilder(this.dataLayer, this.schema, options);
    }
}

