/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.common.schema;

import java.nio.ByteBuffer;
import org.apache.cassandra.spark.common.schema.ColumnType;

public class BooleanType
implements ColumnType<Boolean> {
    private Boolean getBoolean(ByteBuffer bytes) {
        byte value = bytes.get(bytes.position());
        return value != 0;
    }

    @Override
    public Boolean parseColumn(ByteBuffer buffer, int length) {
        byte[] value = new byte[length];
        buffer.get(value, 0, length);
        return this.getBoolean(ByteBuffer.wrap(value));
    }

    @Override
    public ByteBuffer serialize(Boolean value) {
        return ByteBuffer.allocate(1).put(0, (byte)(value != false ? 1 : 0));
    }
}

