/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.spark.data.CassandraTypes;
import org.apache.cassandra.spark.data.TypeConverter;
import org.jetbrains.annotations.NotNull;

public class CqlField
implements Serializable,
Comparable<CqlField> {
    private static final long serialVersionUID = 42L;
    public static final int NO_TTL = 0;
    public static final Comparator<String> STRING_COMPARATOR = String::compareTo;
    public static final Comparator<Byte> BYTE_COMPARATOR = CqlField::compareBytes;
    public static final Comparator<Long> LONG_COMPARATOR = Long::compareTo;
    public static final Comparator<Integer> INTEGER_COMPARATOR = Integer::compareTo;
    public static final Comparator<byte[]> BYTE_ARRAY_COMPARATOR = UnsignedBytes.lexicographicalComparator();
    public static final Comparator<Boolean> BOOLEAN_COMPARATOR = Boolean::compareTo;
    public static final Comparator<Double> DOUBLE_COMPARATOR = Double::compareTo;
    public static final Comparator<Void> VOID_COMPARATOR_COMPARATOR = (first, second) -> 0;
    public static final Comparator<Float> FLOAT_COMPARATOR = Float::compareTo;
    public static final Comparator<Short> SHORT_COMPARATOR = Short::compare;
    public static final Comparator<String> UUID_COMPARATOR = Comparator.comparing(UUID::fromString);
    public static final Comparator<BigDecimal> BIGDECIMAL_COMPARATOR = Comparator.naturalOrder();
    private final String name;
    private final boolean isPartitionKey;
    private final boolean isClusteringColumn;
    private final boolean isStaticColumn;
    private final CqlType type;
    private final int position;

    private static int compareBytes(byte first, byte second) {
        return first - second;
    }

    public CqlField(boolean isPartitionKey, boolean isClusteringColumn, boolean isStaticColumn, String name, CqlType type, int position) {
        Preconditions.checkArgument((!isPartitionKey || !isClusteringColumn ? 1 : 0) != 0, (Object)"Field cannot be both partition key and clustering key");
        Preconditions.checkArgument((!isPartitionKey || !isStaticColumn ? 1 : 0) != 0, (Object)"Field cannot be both partition key and static column");
        Preconditions.checkArgument((!isClusteringColumn || !isStaticColumn ? 1 : 0) != 0, (Object)"Field cannot be both clustering key and static column");
        this.isPartitionKey = isPartitionKey;
        this.isClusteringColumn = isClusteringColumn;
        this.isStaticColumn = isStaticColumn;
        this.name = name;
        this.type = type;
        this.position = position;
    }

    public boolean isPartitionKey() {
        return this.isPartitionKey;
    }

    public boolean isPrimaryKey() {
        return this.isPartitionKey || this.isClusteringColumn;
    }

    public boolean isClusteringColumn() {
        return this.isClusteringColumn;
    }

    public boolean isStaticColumn() {
        return this.isStaticColumn;
    }

    public boolean isValueColumn() {
        return !this.isPartitionKey && !this.isClusteringColumn && !this.isStaticColumn;
    }

    public boolean isNonValueColumn() {
        return !this.isValueColumn();
    }

    public String name() {
        return this.name;
    }

    public CqlType type() {
        return this.type;
    }

    public Object deserializeToType(TypeConverter converter, ByteBuffer buffer) {
        return this.deserializeToType(converter, buffer, false);
    }

    public Object deserializeToType(TypeConverter converter, ByteBuffer buffer, boolean isFrozen) {
        return this.type().deserializeToType(converter, buffer, isFrozen);
    }

    public Object deserializeToJavaType(ByteBuffer buffer) {
        return this.type().deserializeToJavaType(buffer, false);
    }

    public Object deserializeToJavaType(ByteBuffer buffer, boolean isFrozen) {
        return this.type().deserializeToJavaType(buffer, isFrozen);
    }

    public ByteBuffer serialize(Object value) {
        return this.type.serialize(value);
    }

    public String cqlTypeName() {
        return this.type.cqlName();
    }

    public int position() {
        return this.position;
    }

    @VisibleForTesting
    public CqlField cloneWithPosition(int position) {
        return new CqlField(this.isPartitionKey, this.isClusteringColumn, this.isStaticColumn, this.name, this.type, position);
    }

    public String toString() {
        return this.name + " (" + String.valueOf(this.type) + ")";
    }

    @Override
    public int compareTo(@NotNull CqlField that) {
        return Integer.compare(this.position, that.position);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.isPartitionKey, this.isClusteringColumn, this.isStaticColumn, this.type, this.position);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        CqlField that = (CqlField)other;
        return Objects.equals(this.name, that.name) && this.isPartitionKey == that.isPartitionKey && this.isClusteringColumn == that.isClusteringColumn && this.isStaticColumn == that.isStaticColumn && Objects.equals(this.type, that.type) && this.position == that.position;
    }

    public static UnsupportedOperationException notImplemented(CqlType type) {
        return CqlField.notImplemented(type.toString());
    }

    public static UnsupportedOperationException notImplemented(String type) {
        return new UnsupportedOperationException(type + " type not implemented");
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<CqlField> {
        private final CassandraTypes cassandraTypes;

        public Serializer(CassandraTypes cassandraTypes) {
            this.cassandraTypes = cassandraTypes;
        }

        public CqlField read(Kryo kryo, Input input, Class type) {
            return new CqlField(input.readBoolean(), input.readBoolean(), input.readBoolean(), input.readString(), CqlType.read(input, this.cassandraTypes), input.readInt());
        }

        public void write(Kryo kryo, Output output, CqlField field) {
            output.writeBoolean(field.isPartitionKey());
            output.writeBoolean(field.isClusteringColumn());
            output.writeBoolean(field.isStaticColumn());
            output.writeString(field.name());
            field.type().write(output);
            output.writeInt(field.position());
        }
    }

    public static enum SortOrder {
        ASC,
        DESC;

    }

    public static interface CqlUdtBuilder {
        public CqlUdtBuilder withField(String var1, CqlType var2);

        public CqlUdt build();
    }

    public static interface CqlUdt
    extends CqlType {
        public CqlFrozen frozen();

        public String createStatement(CassandraTypes var1, String var2);

        public String keyspace();

        public List<CqlField> fields();

        public CqlField field(String var1);

        public CqlField field(int var1);

        public ByteBuffer serializeUdt(Map<String, Object> var1);

        public Map<String, Object> deserializeUdt(TypeConverter var1, ByteBuffer var2, boolean var3);

        @Override
        default public boolean isComplex() {
            return true;
        }
    }

    public static interface CqlFrozen
    extends CqlType {
        public CqlType inner();

        @Override
        default public boolean isFrozen() {
            return true;
        }
    }

    public static interface CqlTuple
    extends CqlCollection {
        public ByteBuffer serializeTuple(Object[] var1);

        public Object[] deserializeTuple(ByteBuffer var1, boolean var2);
    }

    public static interface CqlList
    extends CqlCollection {
    }

    public static interface CqlSet
    extends CqlCollection {
    }

    public static interface CqlMap
    extends CqlCollection {
        public CqlType keyType();

        public CqlType valueType();
    }

    public static interface CqlCollection
    extends CqlType {
        public CqlFrozen frozen();

        public List<CqlType> types();

        public CqlType type();

        public CqlType type(int var1);

        @Override
        default public boolean isComplex() {
            return true;
        }
    }

    public static interface CqlCustom
    extends CqlType {
        public String customTypeClassName();
    }

    public static interface NativeType
    extends CqlType {
    }

    public static interface CqlType
    extends Serializable {
        public boolean isSupported();

        default public boolean isFrozen() {
            return false;
        }

        default public boolean isComplex() {
            return false;
        }

        default public boolean supportedAsPrimaryKeyColumn() {
            return true;
        }

        default public boolean supportedAsMapKey() {
            return true;
        }

        default public boolean supportedAsSetElement() {
            return true;
        }

        default public Object deserializeToType(TypeConverter converter, ByteBuffer buffer) {
            return this.deserializeToType(converter, buffer, this.isFrozen());
        }

        default public Object deserializeToType(TypeConverter converter, ByteBuffer buffer, boolean isFrozen) {
            Object value = this.deserializeToJavaType(buffer, isFrozen);
            return value != null ? converter.convert(this, value, isFrozen) : null;
        }

        default public Object deserializeToJavaType(ByteBuffer buffer) {
            return this.deserializeToJavaType(buffer, this.isFrozen());
        }

        public Object deserializeToJavaType(ByteBuffer var1, boolean var2);

        public ByteBuffer serialize(Object var1);

        public CassandraVersion version();

        public InternalType internalType();

        public String name();

        public String cqlName();

        public void write(Output var1);

        public Set<CqlUdt> udts();

        @VisibleForTesting
        public int cardinality(int var1);

        default public Object randomValue() {
            return this.randomValue(16);
        }

        @VisibleForTesting
        public Object randomValue(int var1);

        @VisibleForTesting
        public Object convertForCqlWriter(Object var1, CassandraVersion var2, boolean var3);

        public static void write(CqlType type, Output out) {
            out.writeInt(type.internalType().ordinal());
        }

        public static CqlType read(Input input, CassandraTypes cassandraTypes) {
            InternalType internalType = InternalType.values()[input.readInt()];
            return cassandraTypes.readType(internalType, input);
        }

        public static enum InternalType {
            NativeCql,
            Set,
            List,
            Map,
            Frozen,
            Udt,
            Tuple;


            public static InternalType fromString(String name) {
                switch (name.toLowerCase()) {
                    case "set": {
                        return Set;
                    }
                    case "list": {
                        return List;
                    }
                    case "map": {
                        return Map;
                    }
                    case "tuple": {
                        return Tuple;
                    }
                    case "udt": {
                        return Udt;
                    }
                    case "frozen": {
                        return Frozen;
                    }
                }
                return NativeCql;
            }
        }
    }
}

