/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.schemastore;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.Nullable;

public interface SchemaStore {
    public Schema getSchema(String var1, String var2);

    @Nullable
    default public String getVersion(String namespace, String name) {
        Schema schema = this.getSchema(namespace, name);
        if (schema == null) {
            return null;
        }
        return UUID.nameUUIDFromBytes(schema.toString().getBytes(StandardCharsets.UTF_8)).toString();
    }

    public GenericDatumWriter<GenericRecord> getWriter(String var1, String var2);

    public GenericDatumReader<GenericRecord> getReader(String var1, String var2);
}

